/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class PgSQLJSONArrayExtractByIndexSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;

    public PgSQLJSONArrayExtractByIndexSQLFunction(List<ColumnExpression> concatExpressions) {
        if (EasyCollectionUtil.isEmpty(concatExpressions)) {
            throw new IllegalArgumentException("PgSQLJSONArrayExtractByIndexSQLFunction columns empty");
        }
        this.columnExpressions = concatExpressions;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("PgSQLJSONArrayExtractByIndexSQLFunction columns size != 2");
        }
        List<ColumnExpression> jsonKeyExpressions = this.columnExpressions.subList(1, this.columnExpressions.size());
        List params = EasyCollectionUtil.select(jsonKeyExpressions, (t, i) -> "{" + i + 1 + "}");
        return String.format("({0} -> %s)", String.join((CharSequence)".", params));
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

