/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.func;

import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncValueExpression;
import com.easy.query.core.func.column.impl.ColumnFuncValueExpressionImpl;
import com.easy.query.core.func.def.impl.AbstractLikeSQLFunction;
import java.util.List;

public class PgSQLLikeSQLFunction
extends AbstractLikeSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final SQLLikeEnum sqlLikeEnum;

    public PgSQLLikeSQLFunction(List<ColumnExpression> columnExpressions, SQLLikeEnum sqlLikeEnum) {
        this.columnExpressions = columnExpressions;
        this.sqlLikeEnum = sqlLikeEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        String valueString;
        Object value;
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("like arguments != 2");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(1);
        ColumnFuncValueExpression columnFuncValueExpression = this.getColumnFuncValueExpression(columnExpression);
        if (columnFuncValueExpression != null && (value = columnFuncValueExpression.getValue()) instanceof String && ((valueString = (String)value).contains("%") || valueString.contains("_"))) {
            String escapeValue = this.escape(valueString);
            ColumnFuncValueExpressionImpl columnFuncEscapeValueExpression = new ColumnFuncValueExpressionImpl((Object)escapeValue);
            this.columnExpressions.set(1, (ColumnExpression)columnFuncEscapeValueExpression);
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
                return "{0} LIKE CONCAT(({1})::TEXT,'%') ESCAPE '\\'";
            }
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
                return "{0} LIKE CONCAT('%',({1})::TEXT) ESCAPE '\\'";
            }
            return "{0} LIKE CONCAT('%',({1})::TEXT,'%') ESCAPE '\\'";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
            return "{0} LIKE CONCAT(({1})::TEXT,'%')";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
            return "{0} LIKE CONCAT('%',(({1})::TEXT)::TEXT)";
        }
        return "{0} LIKE CONCAT('%',(({1})::TEXT)::TEXT,'%')";
    }

    private String escape(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

