package com.easy.query.processor;


import com.easy.query.core.annotation.ColumnIgnore;
import com.easy.query.core.annotation.EntityProxy;
import com.easy.query.core.util.EasyStringUtil;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

/**
 * create time 2023/6/24 14:17
 * 文件说明
 *
 * @author xuejiaming
 */
@SupportedAnnotationTypes({"com.easy.query.core.annotation.EntityProxy"})
@SupportedSourceVersion(SourceVersion.RELEASE_8)
public class ProxyGenerateProcessor extends AbstractProcessor {
    private static final Map<String,String> TYPE_MAPPING=new HashMap<>();
    static{
        TYPE_MAPPING.put("float","java.lang.Float");
        TYPE_MAPPING.put("double","java.lang.Double");
        TYPE_MAPPING.put("short","java.lang.Short");
        TYPE_MAPPING.put("int","java.lang.Integer");
        TYPE_MAPPING.put("long","java.lang.Long");
        TYPE_MAPPING.put("byte","java.lang.Byte");
        TYPE_MAPPING.put("boolean","java.lang.Boolean");
    }
    private static final String PROXY_TEMPLATE = "package @package;\n" +
            "\n" +
            "import com.easy.query.core.expression.parser.core.available.TableAvailable;\n" +
            "import com.easy.query.core.proxy.AbstractProxyEntity;\n" +
            "import com.easy.query.core.proxy.SQLColumn;\n" +
            "import @entityFullClass;\n" +
            "\n" +
            "/**\n" +
            " * this file automatically generated by easy-query, don't modify it\n" +
            " *\n" +
            " * @author xuejiaming\n" +
            " */\n" +
            "public class @entityClassProxy extends AbstractProxyEntity<@entityClassProxy, @entityClass> {\n" +
            "\n" +
            "    public static final @entityClassProxy @proxyInstanceName = new @entityClassProxy();\n" +
            "    private static final Class<@entityClass> entityClass = @entityClass.class;\n" +
            "    private final TableAvailable table;\n" +
            "\n" +
            "    private @entityClassProxy() {\n" +
            "        this.table = null;\n" +
            "    }\n" +
            "\n" +
            "    public @entityClassProxy(TableAvailable table) {\n" +
            "        this.table = table;\n" +
            "    }\n" +
            "\n" +
            "    @fieldContent" +
            "\n" +
            "    @Override\n" +
            "    public TableAvailable getTable() {\n" +
            "        return table;\n" +
            "    }\n" +
            "\n" +
            "    @Override\n" +
            "    public Class<@entityClass> getEntityClass() {\n" +
            "        return entityClass;\n" +
            "    }\n" +
            "\n" +
            "    @Override\n" +
            "    public @entityClassProxy create(TableAvailable table) {\n" +
            "        return new @entityClassProxy(table);\n" +
            "    }\n" +
            "}";

    private static final String FIELD_TEMPLATE="\n" +
            "    @comment\n" +
            "    public SQLColumn<@propertyType> @property(){\n" +
            "        return get(\"@property\");\n" +
            "    }";

    private static final String FIELD_DOC_COMMENT_TEMPLATE="\n" +
            "    /**\n" +
            "     * {@link @entityClass#@property}\n" +
            "     @comment\n" +
            "     */";
    private static final String FIELD_EMPTY_DOC_COMMENT_TEMPLATE="\n" +
            "    /**\n" +
            "     * {@link @entityClass#@property}\n" +
            "     */";
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            EasyQueryProxyProperties props = new EasyQueryProxyProperties(filer);

            String enable = props.getProperties().getProperty("processor.enable", "");
            if ("false".equalsIgnoreCase(enable)) {
                return true;
            }
            String basePath = props.getProperties().getProperty("processor.basePath", "");
//
//            //upperCase, lowerCase, upperCamelCase, lowerCamelCase
//            String proxyNameStyle = props.getProperties().getProperty("processor.proxyInstanceNameStyle", "upperCase");

            //代理类后缀
            String proxyClassSuffix = props.getProperties().getProperty("processor.proxyClassSuffix", "Proxy");
            String defaultProxyInstanceName = props.getProperties().getProperty("processor.proxyInstanceName", "DEFAULT");

            //待忽略对象后缀
            String[] entityIgnoreSuffixes = props.getProperties().getProperty("processor.entity.ignoreSuffixes", "").split(",");

            AtomicReference<String> entityClassNameReference = new AtomicReference<>();

//            StringBuilder tablesContent = new StringBuilder();
            roundEnv.getElementsAnnotatedWith(EntityProxy.class).forEach((Consumer<Element>) entityClassElement -> {

                String proxyEntityName = entityClassElement.getSimpleName().toString();

                for (String entityIgnoreSuffix : entityIgnoreSuffixes) {
                    if (proxyEntityName.endsWith(entityIgnoreSuffix.trim())) {
                        proxyEntityName = proxyEntityName.substring(0, proxyEntityName.length() - entityIgnoreSuffix.length());
                        break;
                    }
                }
                EntityProxy entityProxy = entityClassElement.getAnnotation(EntityProxy.class);

                entityClassNameReference.set(entityClassElement.toString());

                String proxyInstanceName = EasyStringUtil.isBlank(entityProxy.value())?defaultProxyInstanceName:entityProxy.value();
                if(EasyStringUtil.isBlank(proxyInstanceName)){
                    proxyInstanceName=buildName(entityClassNameReference+"Proxy","upperCase");
                }
                HashSet<String> ignoreProperties = new HashSet<>(Arrays.asList(entityProxy.ignoreProperties()));


                StringBuilder fieldContent = new StringBuilder();
                TypeElement classElement = (TypeElement) entityClassElement;
                do {
                    fillPropertyAndColumns(fieldContent, classElement,ignoreProperties);
                    classElement = (TypeElement) typeUtils.asElement(classElement.getSuperclass());
                } while (classElement != null);


                //每一个 entity 生成一个独立的文件

                String entityFullName = entityClassNameReference.get();
                String realGenPackage = guessTablesPackage(entityFullName);
                String entityClassName = entityClassElement.getSimpleName().toString();
                String content = buildTablesClass(entityClassName, proxyInstanceName, realGenPackage, entityFullName,fieldContent.toString());
                genClass(basePath, realGenPackage, proxyEntityName + proxyClassSuffix, content);

            });
        }
        return false;
    }
    public  boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }
    /**
     * 获取项目的根目录，也就是根节点 pom.xml 所在的目录
     *
     * @return
     */
    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return getProjectRootPath(file, count);
    }
    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return getProjectRootPath(file.getParentFile(), --count);
        } else {
            if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
                return file.getAbsolutePath();
            } else {
                return getProjectRootPath(file.getParentFile(), --count);
            }
        }
    }
    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }
    private void genClass(String basePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            JavaFileObject sourceFile = filer.createSourceFile(genPackageName + "." + className);
            if (basePath == null || basePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }


            String defaultGenPath = sourceFile.toUri().getPath();

            //真实的生成代码的目录
            String realPath;

            //用户配置的路径为绝对路径
            if (isAbsolutePath(basePath)) {
                realPath = basePath;
            }
            //配置的是相对路径，那么则以项目根目录为相对路径
            else {
                String projectRootPath = getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, basePath).getAbsolutePath();
            }

            //通过在 test/java 目录下执行编译生成的
            boolean fromTestSource = isFromTestSource(defaultGenPath);
            if (fromTestSource) {
                realPath = new File(realPath, "src/test/java").getAbsolutePath();
            } else {
                realPath = new File(realPath, "src/main/java").getAbsolutePath();
            }

            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by easy-query processor for: " + genJavaFile.getParentFile());
                return;
            }

            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException ignored) {
                }
            }
        }
    }
    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }


    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] -= ('a' - 'A');
            return new String(arr);
        }
        return string;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] += ('a' - 'A');
            return new String(arr);
        }
        return str;
    }

    //upperCase, lowerCase, upperCamelCase, lowerCamelCase
    private static String buildName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return camelToUnderline(name).toUpperCase();
        } else if ("lowerCase".equalsIgnoreCase(style)) {
            return camelToUnderline(name).toLowerCase();
        } else if ("upperCamelCase".equalsIgnoreCase(style)) {
            return firstCharToUpperCase(name);
        }
        //lowerCamelCase
        else {
            return firstCharToLowerCase(name);
        }
    }
    private String buildTablesClass(String entityClass, String proxyInstanceName, String realGenPackage, String entityFullName,String fieldContent) {

        String tableDef = PROXY_TEMPLATE.replace("@package", realGenPackage)
                .replace("@entityFullClass", entityFullName)
                .replace("@proxyInstanceName", proxyInstanceName)
                .replace("@fieldContent", fieldContent)
                .replace("@entityClass", entityClass);

        return tableDef;
    }
    private String guessTablesPackage(String entityClassName) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClassName.contains(".")) {
            guessPackage.append("proxy");// = "table";
        } else {
            guessPackage.append(entityClassName, 0, entityClassName.lastIndexOf(".")).append(".proxy");
        }
        return guessPackage.toString();
    }
    private void fillPropertyAndColumns(StringBuilder filedContent, TypeElement classElement,Set<String> ignoreProperties) {
        for (Element fieldElement : classElement.getEnclosedElements()) {

            //all fields
            if (ElementKind.FIELD == fieldElement.getKind()) {


                Set<Modifier> modifiers = fieldElement.getModifiers();
                if (modifiers.contains(Modifier.STATIC)) {
                    //ignore static fields
                    continue;
                }

                String propertyName = fieldElement.toString();
                if(ignoreProperties.contains(propertyName)){
                    continue;
                }
                ColumnIgnore column = fieldElement.getAnnotation(ColumnIgnore.class);
                if (column != null) {
                    continue;
                }


                TypeMirror typeMirror = fieldElement.asType();
                Element element = typeUtils.asElement(typeMirror);
                if (element != null) {
                    typeMirror = element.asType();
                }

                String typeString =typeMirror.toString().trim();
                String fieldGenericType = TYPE_MAPPING.getOrDefault(typeString, typeString);

                String docComment = elementUtils.getDocComment(fieldElement);
                String fieldComment = getFiledComment(docComment);
                String fieldString = FIELD_TEMPLATE
                        .replace("@comment", fieldComment)
                        .replace("@propertyType", fieldGenericType)
                        .replace("@property", propertyName);
                filedContent.append(fieldString);
            }
        }
    }
    private String getFiledComment(String docComment){
        if(docComment == null){
            return FIELD_EMPTY_DOC_COMMENT_TEMPLATE;
        }
        String[] commentLines = docComment.trim().split("\n");
        StringBuilder fieldComment=new StringBuilder();
        fieldComment.append("* ").append(commentLines[0]);
        for (int i = 1; i < commentLines.length; i++) {
            fieldComment.append("\n     *").append(commentLines[i]);
        }
        return FIELD_DOC_COMMENT_TEMPLATE
                .replace("@comment", fieldComment.toString());
    }

}
