/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.templates;

import com.easy.query.processor.templates.AptFileCompiler;
import com.easy.query.processor.templates.AptPropertyInfo;
import com.easy.query.processor.templates.AptValueObjectInfo;

public class AptCreatorHelper {
    public static String createProxy(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, aptValueObjectInfo);
        String valueObjectContent = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, aptValueObjectInfo);
        String proxyTemplate = "package @{package};\n\nimport com.easy.query.core.expression.parser.core.available.TableAvailable;\nimport com.easy.query.core.proxy.AbstractProxyEntity;\nimport com.easy.query.core.proxy.SQLColumn;\n@{imports}\n/**\n * this file automatically generated by easy-query, don't modify it\n *\n * @author xuejiaming\n */\npublic class @{entityClassProxy} extends AbstractProxyEntity<@{entityClassProxy}, @{entityClass}> {\n\n    private static final Class<@{entityClass}> entityClass = @{entityClass}.class;\n    public static @{entityClassProxy} createTable() {\n        return new @{entityClassProxy}();\n    }\n\n    private @{entityClassProxy}() {\n    }\n\n    @{fieldContent}\n    @Override\n    public Class<@{entityClass}> getEntityClass() {\n        return entityClass;\n    }\n\n    @{valueObjectContext}\n}".replace("@{package}", aptFileCompiler.getPackageName()).replace("@{imports}", String.join((CharSequence)"\n", aptFileCompiler.getImports())).replace("@{entityClass}", aptFileCompiler.getEntityClassName()).replace("@{entityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{fieldContent}", propertyContent).replace("@{valueObjectContext}", valueObjectContent);
        return proxyTemplate;
    }

    private static String renderPropertyUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder filedContent = new StringBuilder();
        for (AptPropertyInfo property : aptValueObjectInfo.getProperties()) {
            String fieldString;
            if (property.isValueObject()) {
                fieldString = "\n    @{comment}\n    public @{entityClass}Proxy @{property}() {\n        return getValueObject(new @{entityClass}Proxy(getTable(), getValueProperty(\"@{property}\")));\n    }".replace("@{entityClass}", property.getEntityName()).replace("@{comment}", property.getComment()).replace("@{propertyType}", property.getPropertyType()).replace("@{property}", property.getPropertyName());
                filedContent.append(fieldString);
                continue;
            }
            fieldString = "\n    @{comment}\n    public SQLColumn<@{entityClassProxy},@{propertyType}> @{property}(){\n        return get(\"@{property}\");\n    }".replace("@{entityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{comment}", property.getComment()).replace("@{propertyType}", property.getPropertyType()).replace("@{property}", property.getPropertyName());
            filedContent.append(fieldString);
        }
        return filedContent.toString();
    }

    private static String renderValueObjectUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder valueObjectContentBuilder = new StringBuilder();
        for (AptValueObjectInfo valueObject : aptValueObjectInfo.getChildren()) {
            String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, valueObject);
            String vc = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, valueObject);
            String valueObjectContent = "\n    public static class @{entityClass}Proxy extends AbstractValueObjectProxyEntity<@{mainEntityClassProxy}, @{entityClass}> {\n\n        private @{entityClass}Proxy(TableAvailable table, String propertyName) {\n            super(table, propertyName);\n        }\n\n        @{fieldContent}\n        @{valueObjectContext}    }".replace("@{entityClass}", valueObject.getEntityName()).replace("@{mainEntityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{fieldContent}", propertyContent).replace("@{valueObjectContext}", vc);
            valueObjectContentBuilder.append(valueObjectContent);
            valueObjectContentBuilder.append("\n");
        }
        return valueObjectContentBuilder.toString();
    }
}

