/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.helper;

import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.processor.helper.PropertyColumn;

public class AptPropertyInfo {
    private final String propertyName;
    private final PropertyColumn propertyColumn;
    private final String comment;
    private final String entityName;
    private final boolean valueObject;
    private final boolean includeProperty;
    private final boolean includeManyProperty;
    private final String sqlColumn;
    private final String sqlColumnMethod;
    private final String proxyPropertyName;

    public AptPropertyInfo(String propertyName, PropertyColumn propertyColumn, String comment, String entityName, boolean valueObject, boolean includeProperty, boolean includeManyProperty, String proxyPropertyName) {
        this.propertyName = propertyName;
        this.propertyColumn = propertyColumn;
        this.comment = comment;
        this.entityName = entityName;
        this.valueObject = valueObject;
        this.includeProperty = includeProperty;
        this.includeManyProperty = includeManyProperty;
        this.sqlColumn = includeProperty ? "SQLNavigateColumn" : propertyColumn.getSqlColumnName();
        this.sqlColumnMethod = includeProperty ? "getNavigate" : propertyColumn.getSQLColumnMethod();
        this.proxyPropertyName = proxyPropertyName;
    }

    public String getProxyPropertyName() {
        if (EasyStringUtil.isNotBlank((String)this.proxyPropertyName)) {
            return this.proxyPropertyName;
        }
        return this.propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getComment() {
        return this.comment;
    }

    public String getPropertyType() {
        return this.propertyColumn.getPropertyType();
    }

    public boolean isAnyType() {
        return this.propertyColumn.isAnyType();
    }

    public String getPropertyTypeClass() {
        return this.propertyColumn.getPropertyTypeClass(this.includeProperty);
    }

    public String getPropertyShortType() {
        String propertyType = this.propertyColumn.getPropertyType();
        if (propertyType.contains(".")) {
            return propertyType.substring(propertyType.lastIndexOf(".") + 1);
        }
        return propertyType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isValueObject() {
        return this.valueObject;
    }

    public String getSqlColumn() {
        return this.sqlColumn;
    }

    public String getSqlColumnMethod() {
        return this.sqlColumnMethod;
    }

    public boolean isIncludeProperty() {
        return this.includeProperty;
    }

    public String getNavigateProxyName() {
        return this.propertyColumn.getNavigateProxyName();
    }

    public boolean isIncludeManyProperty() {
        return this.includeManyProperty;
    }
}

