/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.generate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassProxyGenerator {
    public final List<String> proxyTemplateStaticParts;
    public final List<String> proxyTemplatePlaceholders;

    public ClassProxyGenerator(String template) {
        ArrayList<String> staticParts = new ArrayList<String>();
        ArrayList<String> placeholders = new ArrayList<String>();
        Pattern pattern = Pattern.compile("@\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(template);
        int lastIndex = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            staticParts.add(template.substring(lastIndex, start));
            placeholders.add(matcher.group(1));
            lastIndex = end;
        }
        staticParts.add(template.substring(lastIndex));
        this.proxyTemplateStaticParts = Collections.unmodifiableList(staticParts);
        this.proxyTemplatePlaceholders = Collections.unmodifiableList(placeholders);
    }

    public String generate(Map<String, String> replacements) {
        StringBuilder sb = new StringBuilder();
        List<String> staticParts = this.proxyTemplateStaticParts;
        List<String> placeholders = this.proxyTemplatePlaceholders;
        for (int i = 0; i < placeholders.size(); ++i) {
            sb.append(staticParts.get(i));
            String placeholder = placeholders.get(i);
            String replacement = replacements.getOrDefault(placeholder, "");
            if (replacement == null) {
                throw new IllegalStateException("Missing replacement for placeholder: @" + placeholder);
            }
            sb.append(replacement);
        }
        sb.append(staticParts.get(staticParts.size() - 1));
        return sb.toString();
    }
}

