/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.helper;

import com.easy.query.core.annotation.Table;
import com.easy.query.processor.helper.AptSelectorInfo;
import java.util.LinkedHashSet;
import java.util.Set;

public class AptFileCompiler {
    private final String entityClassName;
    private final String entityClassProxyName;
    private final Table tableAnnotation;
    private final AptSelectorInfo selectorInfo;
    private final String packageName;
    private Set<String> imports;

    public AptFileCompiler(String packageName, String entityClassName, String entityClassProxyName, Table tableAnnotation, AptSelectorInfo selectorInfo) {
        this.packageName = packageName;
        this.entityClassName = entityClassName;
        this.entityClassProxyName = entityClassProxyName;
        this.tableAnnotation = tableAnnotation;
        this.selectorInfo = selectorInfo;
        this.imports = new LinkedHashSet<String>();
    }

    public String getEntityClassProxyName() {
        return this.entityClassProxyName;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void addImports(String fullClassPackageName) {
        if (fullClassPackageName != null) {
            this.imports.add("import " + fullClassPackageName + ";");
        }
    }

    public boolean isTableEntity() {
        return this.tableAnnotation != null;
    }

    public AptSelectorInfo getSelectorInfo() {
        return this.selectorInfo;
    }
}

