/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.helper;

import com.easy.query.processor.FieldRenderVal;
import com.easy.query.processor.helper.AptConstant;
import com.easy.query.processor.helper.AptFileCompiler;
import com.easy.query.processor.helper.AptPropertyInfo;
import com.easy.query.processor.helper.AptSelectPropertyInfo;
import com.easy.query.processor.helper.AptSelectorInfo;
import com.easy.query.processor.helper.AptValueObjectInfo;
import java.util.HashMap;

public class AptCreatorHelper {
    public static String createProxy(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        String selectorContent = AptCreatorHelper.renderSelectorUI(aptFileCompiler);
        FieldRenderVal fieldRenderVal = AptCreatorHelper.renderStaticFieldCommentUI(aptFileCompiler);
        String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, aptValueObjectInfo);
        String valueObjectContent = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, aptValueObjectInfo);
        HashMap<String, String> replacements = new HashMap<String, String>(8);
        replacements.put("package", aptFileCompiler.getPackageName());
        replacements.put("imports", String.join((CharSequence)"\n", aptFileCompiler.getImports()));
        replacements.put("entityClass", aptFileCompiler.getEntityClassName());
        replacements.put("entityClassProxy", aptFileCompiler.getEntityClassProxyName());
        replacements.put("fieldContent", propertyContent);
        replacements.put("valueObjectContext", valueObjectContent);
        replacements.put("selectorContext", selectorContent);
        replacements.put("fieldStaticContext", fieldRenderVal.staticField.toString());
        return AptConstant.PROXY_TEMPLATE_GENERATOR.generate(replacements);
    }

    private static String renderPropertyUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder filedContent = new StringBuilder();
        for (AptPropertyInfo property : aptValueObjectInfo.getProperties()) {
            String fieldString;
            HashMap<String, String> replacements;
            if (property.isValueObject()) {
                replacements = new HashMap<String, String>(6);
                replacements.put("entityClass", property.getEntityName());
                replacements.put("comment", property.getComment());
                replacements.put("propertyType", property.getPropertyType());
                replacements.put("property", property.getPropertyName());
                replacements.put("proxyProperty", property.getProxyPropertyName());
                fieldString = AptConstant.FIELD_VALUE_OBJECT_TEMPLATE_GENERATOR.generate(replacements);
                filedContent.append(fieldString);
                continue;
            }
            if (property.isIncludeProperty() && property.getNavigateProxyName() != null) {
                if (property.isIncludeManyProperty()) {
                    replacements = new HashMap(6);
                    replacements.put("entityClassProxy", aptFileCompiler.getEntityClassProxyName());
                    replacements.put("propertyProxy", property.getNavigateProxyName());
                    replacements.put("comment", property.getComment());
                    replacements.put("propertyType", property.getPropertyType());
                    replacements.put("property", property.getPropertyName());
                    replacements.put("proxyProperty", property.getProxyPropertyName());
                    fieldString = AptConstant.FIELD_NAVIGATES_TEMPLATE_GENERATOR.generate(replacements);
                    filedContent.append(fieldString);
                    continue;
                }
                replacements = new HashMap(4);
                replacements.put("propertyProxy", property.getNavigateProxyName());
                replacements.put("comment", property.getComment());
                replacements.put("property", property.getPropertyName());
                replacements.put("proxyProperty", property.getProxyPropertyName());
                fieldString = AptConstant.FIELD_NAVIGATE_TEMPLATE_GENERATOR.generate(replacements);
                filedContent.append(fieldString);
                continue;
            }
            if (property.isAnyType()) {
                replacements = new HashMap(8);
                replacements.put("entityClassProxy", aptFileCompiler.getEntityClassProxyName());
                replacements.put("comment", property.getComment());
                replacements.put("propertyType", property.getPropertyType());
                replacements.put("propertyTypeClass", property.getPropertyTypeClass());
                replacements.put("property", property.getPropertyName());
                replacements.put("proxyProperty", property.getProxyPropertyName());
                replacements.put("SQLColumn", property.getSqlColumn());
                replacements.put("sqlColumnMethod", property.getSqlColumnMethod());
                fieldString = AptConstant.ANY_FIELD_TEMPLATE_GENERATOR.generate(replacements);
                filedContent.append(fieldString);
                continue;
            }
            replacements = new HashMap(6);
            replacements.put("entityClassProxy", aptFileCompiler.getEntityClassProxyName());
            replacements.put("comment", property.getComment());
            replacements.put("property", property.getPropertyName());
            replacements.put("proxyProperty", property.getProxyPropertyName());
            replacements.put("SQLColumn", property.getSqlColumn());
            replacements.put("sqlColumnMethod", property.getSqlColumnMethod());
            fieldString = AptConstant.FIELD_TEMPLATE_GENERATOR.generate(replacements);
            filedContent.append(fieldString);
        }
        return filedContent.toString();
    }

    private static String renderSelectorUI(AptFileCompiler aptFileCompiler) {
        String fieldSelectorContent = AptCreatorHelper.renderSelectorPropertyUI(aptFileCompiler);
        AptSelectorInfo selectorInfo = aptFileCompiler.getSelectorInfo();
        HashMap<String, String> replacements = new HashMap<String, String>(4);
        replacements.put("entityClass", aptFileCompiler.getEntityClassName());
        replacements.put("selectorName", selectorInfo.getName());
        replacements.put("entityClassProxy", aptFileCompiler.getEntityClassProxyName());
        replacements.put("fieldSelectorContent", fieldSelectorContent);
        return AptConstant.PROXY_SELECTOR_TEMPLATE_GENERATOR.generate(replacements);
    }

    private static FieldRenderVal renderStaticFieldCommentUI(AptFileCompiler aptFileCompiler) {
        FieldRenderVal fieldRenderVal = new FieldRenderVal();
        AptSelectorInfo selectorInfo = aptFileCompiler.getSelectorInfo();
        for (AptSelectPropertyInfo property : selectorInfo.getProperties()) {
            String staticFiled = "        public static final String @{property} = \"@{property}\";\n".replace("@{property}", property.getPropertyName());
            fieldRenderVal.staticField.append(staticFiled);
        }
        return fieldRenderVal;
    }

    private static String renderSelectorPropertyUI(AptFileCompiler aptFileCompiler) {
        AptSelectorInfo selectorInfo = aptFileCompiler.getSelectorInfo();
        StringBuilder filedContent = new StringBuilder();
        for (AptSelectPropertyInfo property : selectorInfo.getProperties()) {
            HashMap<String, String> replacements = new HashMap<String, String>(3);
            replacements.put("selectorName", selectorInfo.getName());
            replacements.put("comment", property.getComment());
            replacements.put("proxyProperty", property.getProxyPropertyName());
            String fieldString = AptConstant.FIELD_SELECTOR_PROPERTY_TEMPLATE_GENERATOR.generate(replacements);
            filedContent.append(fieldString);
        }
        return filedContent.toString();
    }

    private static String renderValueObjectUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder valueObjectContentBuilder = new StringBuilder();
        for (AptValueObjectInfo valueObject : aptValueObjectInfo.getChildren()) {
            String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, valueObject);
            String vc = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, valueObject);
            HashMap<String, String> replacements = new HashMap<String, String>(4);
            replacements.put("entityClass", valueObject.getEntityName());
            replacements.put("mainEntityClassProxy", aptFileCompiler.getEntityClassProxyName());
            replacements.put("fieldContent", propertyContent);
            replacements.put("valueObjectContext", vc);
            String valueObjectContent = AptConstant.FIELD_VALUE_OBJECT_CLASS_TEMPLATE_GENERATOR.generate(replacements);
            valueObjectContentBuilder.append(valueObjectContent);
            valueObjectContentBuilder.append("\n");
        }
        return valueObjectContentBuilder.toString();
    }
}

