/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter;

import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategy;
import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.configuration.QueryConfiguration;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.sharding.initializer.ShardingInitializer;
import com.easy.query.core.sharding.route.manager.DataSourceRouteManager;
import com.easy.query.core.sharding.route.manager.TableRouteManager;
import com.easy.query.core.sharding.rule.datasource.DataSourceRouteRule;
import com.easy.query.core.sharding.rule.table.TableRouteRule;
import com.easy.query.sql.starter.EasyQueryStarterAutoConfiguration;
import com.easy.query.sql.starter.config.EasyQueryInitializeOption;
import com.easy.query.sql.starter.config.EasyQueryProperties;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EasyQueryProperties.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, EasyQueryStarterAutoConfiguration.class})
@ConditionalOnProperty(prefix="easy-query", value={"enable"}, matchIfMissing=true)
public class EasyQueryStarterInitializeAutoConfiguration {
    private final EasyQueryClient easyQuery;
    private final EasyQueryInitializeOption easyQueryInitializeOption;

    public EasyQueryStarterInitializeAutoConfiguration(EasyQueryClient easyQuery, EasyQueryInitializeOption easyQueryInitializeOption) {
        this.easyQuery = easyQuery;
        this.easyQueryInitializeOption = easyQueryInitializeOption;
        this.initialize();
    }

    public void initialize() {
        QueryRuntimeContext runtimeContext = this.easyQuery.getRuntimeContext();
        QueryConfiguration configuration = runtimeContext.getQueryConfiguration();
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getInterceptorMap().entrySet()) {
            configuration.applyInterceptor(entry.getValue());
        }
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getLogicDeleteStrategyMap().entrySet()) {
            configuration.applyLogicDeleteStrategy((LogicDeleteStrategy)entry.getValue());
        }
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getShardingInitializerMap().entrySet()) {
            configuration.applyShardingInitializer((ShardingInitializer)entry.getValue());
        }
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getEncryptionStrategyMap().entrySet()) {
            configuration.applyEncryptionStrategy((EncryptionStrategy)entry.getValue());
        }
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getVersionStrategyMap().entrySet()) {
            configuration.applyEasyVersionStrategy((VersionStrategy)entry.getValue());
        }
        for (Map.Entry<String, Interceptor> entry : this.easyQueryInitializeOption.getValueConverterMap().entrySet()) {
            configuration.applyValueConverter((ValueConverter)entry.getValue());
        }
        TableRouteManager tableRouteManager = runtimeContext.getTableRouteManager();
        for (Map.Entry<String, TableRouteRule<?>> entry : this.easyQueryInitializeOption.getTableRouteRuleMap().entrySet()) {
            tableRouteManager.addRouteRule(entry.getValue());
        }
        DataSourceRouteManager dataSourceRouteManager = runtimeContext.getDataSourceRouteManager();
        for (Map.Entry<String, DataSourceRouteRule<?>> dataSourceRouteRuleEntry : this.easyQueryInitializeOption.getDataSourceRouteRuleMap().entrySet()) {
            dataSourceRouteManager.addRouteRule(dataSourceRouteRuleEntry.getValue());
        }
    }
}

