/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter.con;

import com.easy.query.core.basic.jdbc.con.DataSourceWrapper;
import com.easy.query.core.basic.jdbc.con.EasyConnection;
import com.easy.query.core.basic.jdbc.con.EasyConnectionFactory;
import com.easy.query.core.basic.jdbc.con.EasyDataSourceConnectionFactory;
import com.easy.query.core.basic.jdbc.con.impl.DefaultConnectionManager;
import com.easy.query.core.enums.con.ConnectionStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.sharding.EasyQueryDataSource;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringConnectionManager
extends DefaultConnectionManager {
    public SpringConnectionManager(EasyQueryDataSource easyDataSource, EasyConnectionFactory easyConnectionFactory, EasyDataSourceConnectionFactory easyDataSourceConnectionFactory) {
        super(easyDataSource, easyConnectionFactory, easyDataSourceConnectionFactory);
    }

    public boolean currentThreadInTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive() || this.isOpenTransaction();
    }

    public void closeEasyConnection(EasyConnection easyConnection) {
        if (easyConnection == null) {
            return;
        }
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            if (super.isOpenTransaction()) {
                return;
            }
        } else if (super.isOpenTransaction()) {
            throw new EasyQueryException("repeat transaction can't closed connection");
        }
        DataSourceWrapper dataSourceUnit = this.easyDataSource.getDataSourceNotNull(easyConnection.getDataSourceName(), ConnectionStrategyEnum.ShareConnection);
        DataSourceUtils.releaseConnection((Connection)easyConnection.getConnection(), (DataSource)dataSourceUnit.getDataSourceUnit().getDataSource());
    }
}

