/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter.config;

import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.sql.starter.option.DatabaseEnum;
import com.easy.query.sql.starter.option.NameConversionEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="easy-query")
public class EasyQueryProperties {
    private Boolean enable = false;
    private Boolean deleteThrow = true;
    private DatabaseEnum database;
    private NameConversionEnum nameConversion;
    private SQLExecuteStrategyEnum insertStrategy = SQLExecuteStrategyEnum.DEFAULT;
    private SQLExecuteStrategyEnum updateStrategy = SQLExecuteStrategyEnum.DEFAULT;
    private ConnectionModeEnum connectionMode = ConnectionModeEnum.SYSTEM_AUTO;
    private int maxShardingQueryLimit = 5;
    private int executorMaximumPoolSize = 0;
    private int executorCorePoolSize = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private int executorQueueSize = 1024;
    private String logClass = "com.easy.query.sql.starter.logging.Slf4jImpl";
    private boolean throwIfRouteNotMatch = true;
    private long shardingExecuteTimeoutMillis = 30000L;
    private boolean queryLargeColumn = true;
    private int maxShardingRouteCount = 128;
    private String defaultDataSourceName = "ds0";
    private int defaultDataSourceMergePoolSize = 0;
    private long multiConnWaitTimeoutMillis = 5000L;
    private boolean warningBusy = true;

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getLogClass() {
        return this.logClass;
    }

    public void setLogClass(String logClass) {
        this.logClass = logClass;
    }

    public Boolean getDeleteThrow() {
        return this.deleteThrow;
    }

    public void setDeleteThrow(Boolean deleteThrow) {
        this.deleteThrow = deleteThrow;
    }

    public DatabaseEnum getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseEnum database) {
        this.database = database;
    }

    public NameConversionEnum getNameConversion() {
        return this.nameConversion;
    }

    public void setNameConversion(NameConversionEnum nameConversion) {
        this.nameConversion = nameConversion;
    }

    public SQLExecuteStrategyEnum getInsertStrategy() {
        return this.insertStrategy;
    }

    public void setInsertStrategy(SQLExecuteStrategyEnum insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    public SQLExecuteStrategyEnum getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(SQLExecuteStrategyEnum updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public ConnectionModeEnum getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionModeEnum connectionMode) {
        this.connectionMode = connectionMode;
    }

    public int getMaxShardingQueryLimit() {
        return this.maxShardingQueryLimit;
    }

    public void setMaxShardingQueryLimit(int maxShardingQueryLimit) {
        this.maxShardingQueryLimit = maxShardingQueryLimit;
    }

    public int getExecutorMaximumPoolSize() {
        return this.executorMaximumPoolSize;
    }

    public void setExecutorMaximumPoolSize(int executorMaximumPoolSize) {
        this.executorMaximumPoolSize = executorMaximumPoolSize;
    }

    public int getExecutorCorePoolSize() {
        return this.executorCorePoolSize;
    }

    public void setExecutorCorePoolSize(int executorCorePoolSize) {
        this.executorCorePoolSize = executorCorePoolSize;
    }

    public boolean isThrowIfRouteNotMatch() {
        return this.throwIfRouteNotMatch;
    }

    public void setThrowIfRouteNotMatch(boolean throwIfRouteNotMatch) {
        this.throwIfRouteNotMatch = throwIfRouteNotMatch;
    }

    public long getShardingExecuteTimeoutMillis() {
        return this.shardingExecuteTimeoutMillis;
    }

    public void setShardingExecuteTimeoutMillis(long shardingExecuteTimeoutMillis) {
        this.shardingExecuteTimeoutMillis = shardingExecuteTimeoutMillis;
    }

    public boolean isQueryLargeColumn() {
        return this.queryLargeColumn;
    }

    public void setQueryLargeColumn(boolean queryLargeColumn) {
        this.queryLargeColumn = queryLargeColumn;
    }

    public int getMaxShardingRouteCount() {
        return this.maxShardingRouteCount;
    }

    public void setMaxShardingRouteCount(int maxShardingRouteCount) {
        this.maxShardingRouteCount = maxShardingRouteCount;
    }

    public int getExecutorQueueSize() {
        return this.executorQueueSize;
    }

    public void setExecutorQueueSize(int executorQueueSize) {
        this.executorQueueSize = executorQueueSize;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public int getDefaultDataSourceMergePoolSize() {
        return this.defaultDataSourceMergePoolSize;
    }

    public void setDefaultDataSourceMergePoolSize(int defaultDataSourceMergePoolSize) {
        this.defaultDataSourceMergePoolSize = defaultDataSourceMergePoolSize;
    }

    public long getMultiConnWaitTimeoutMillis() {
        return this.multiConnWaitTimeoutMillis;
    }

    public void setMultiConnWaitTimeoutMillis(long multiConnWaitTimeoutMillis) {
        this.multiConnWaitTimeoutMillis = multiConnWaitTimeoutMillis;
    }

    public boolean isWarningBusy() {
        return this.warningBusy;
    }

    public void setWarningBusy(boolean warningBusy) {
        this.warningBusy = warningBusy;
    }
}

