/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter;

import com.easy.query.core.annotation.EasyQueryTrack;
import com.easy.query.core.basic.extension.track.TrackManager;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class EasyQueryTrackAopConfiguration {
    private final TrackManager trackManager;

    public EasyQueryTrackAopConfiguration(TrackManager trackManager) {
        this.trackManager = trackManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(public * *(..)) && @within(com.easy.query.core.annotation.EasyQueryTrack)")
    public Object easyQueryTrack(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        EasyQueryTrack easyQueryTrack = method.getAnnotation(EasyQueryTrack.class);
        if (easyQueryTrack.enable()) {
            try {
                this.trackManager.begin();
                Object object = pjp.proceed();
                return object;
            }
            finally {
                this.trackManager.release();
            }
        }
        return pjp.proceed();
    }
}

