/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter;

import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.generated.GeneratedKeySQLColumnGenerator;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategy;
import com.easy.query.core.basic.extension.track.update.ValueUpdateAtomicTrack;
import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.configuration.QueryConfiguration;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.sharding.initializer.ShardingInitializer;
import com.easy.query.core.sharding.route.datasource.DataSourceRoute;
import com.easy.query.core.sharding.route.table.TableRoute;
import com.easy.query.core.sharding.router.manager.DataSourceRouteManager;
import com.easy.query.core.sharding.router.manager.TableRouteManager;
import com.easy.query.sql.starter.EasyQueryStarterAutoConfiguration;
import com.easy.query.sql.starter.config.EasyQueryInitializeOption;
import com.easy.query.sql.starter.config.EasyQueryProperties;
import com.easy.query.sql.starter.config.JdbcTypeHandlerReplaceConfigurer;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EasyQueryProperties.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, EasyQueryStarterAutoConfiguration.class})
@ConditionalOnProperty(prefix="easy-query", value={"enable"}, matchIfMissing=true)
public class EasyQueryStarterInitializeAutoConfiguration {
    private final EasyQueryClient easyQuery;
    private final EasyQueryInitializeOption easyQueryInitializeOption;

    public EasyQueryStarterInitializeAutoConfiguration(EasyQueryClient easyQuery, EasyQueryInitializeOption easyQueryInitializeOption) {
        this.easyQuery = easyQuery;
        this.easyQueryInitializeOption = easyQueryInitializeOption;
        this.initialize();
    }

    public void initialize() {
        QueryRuntimeContext runtimeContext = this.easyQuery.getRuntimeContext();
        QueryConfiguration configuration = runtimeContext.getQueryConfiguration();
        JdbcTypeHandlerManager jdbcTypeHandlerManager = runtimeContext.getJdbcTypeHandlerManager();
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getJdbcTypeHandlerMap().entrySet()) {
            JdbcTypeHandlerReplaceConfigurer jdbcTypeHandlerReplaceConfiguration;
            JdbcTypeHandler jdbcTypeHandler = entry.getValue();
            if (!(jdbcTypeHandler instanceof JdbcTypeHandlerReplaceConfigurer) || (jdbcTypeHandlerReplaceConfiguration = (JdbcTypeHandlerReplaceConfigurer)jdbcTypeHandler).allowTypes() == null || jdbcTypeHandlerReplaceConfiguration.allowTypes().isEmpty()) continue;
            boolean replace = jdbcTypeHandlerReplaceConfiguration.replace();
            for (Class<?> allowType : jdbcTypeHandlerReplaceConfiguration.allowTypes()) {
                jdbcTypeHandlerManager.appendHandler(allowType, jdbcTypeHandler, replace);
            }
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getInterceptorMap().entrySet()) {
            configuration.applyInterceptor((Interceptor)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getLogicDeleteStrategyMap().entrySet()) {
            configuration.applyLogicDeleteStrategy((LogicDeleteStrategy)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getShardingInitializerMap().entrySet()) {
            configuration.applyShardingInitializer((ShardingInitializer)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getEncryptionStrategyMap().entrySet()) {
            configuration.applyEncryptionStrategy((EncryptionStrategy)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getVersionStrategyMap().entrySet()) {
            configuration.applyEasyVersionStrategy((VersionStrategy)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getValueConverterMap().entrySet()) {
            configuration.applyValueConverter((ValueConverter)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getColumnValueSQLConverterMap().entrySet()) {
            configuration.applyColumnValueSQLConverter((ColumnValueSQLConverter)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getGeneratedKeySQLColumnGeneratorMap().entrySet()) {
            configuration.applyGeneratedKeySQLColumnGenerator((GeneratedKeySQLColumnGenerator)entry.getValue());
        }
        for (Map.Entry<String, JdbcTypeHandler> entry : this.easyQueryInitializeOption.getValueUpdateAtomicTrackMap().entrySet()) {
            configuration.applyValueUpdateAtomicTrack((ValueUpdateAtomicTrack)entry.getValue());
        }
        TableRouteManager tableRouteManager = runtimeContext.getTableRouteManager();
        for (Map.Entry<String, TableRoute<?>> entry : this.easyQueryInitializeOption.getTableRouteMap().entrySet()) {
            tableRouteManager.addRoute(entry.getValue());
        }
        DataSourceRouteManager dataSourceRouteManager = runtimeContext.getDataSourceRouteManager();
        for (Map.Entry<String, DataSourceRoute<?>> dataSourceRouteEntry : this.easyQueryInitializeOption.getDataSourceRouteMap().entrySet()) {
            dataSourceRouteManager.addRoute(dataSourceRouteEntry.getValue());
        }
    }
}

