/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter;

import com.easy.query.api.proxy.client.EasyProxyQuery;
import com.easy.query.api4j.client.EasyQuery;
import com.easy.query.core.annotation.EasyQueryTrack;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.InvokeTryFinally;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.common.EasyQueryTrackInvoker;
import com.easy.query.core.common.EmptyInvokeTryFinally;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.sql.starter.config.EasyQueryTrackProperties;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@EnableConfigurationProperties(value={EasyQueryTrackProperties.class})
@ConditionalOnProperty(name={"easy-query-track.enable"}, matchIfMissing=true, havingValue="true")
public class EasyQueryTrackAopConfiguration {
    private static final Log log = LogFactory.getLog(EasyQueryTrackAopConfiguration.class);
    private final Map<String, TrackManager> trackManagerMap = new HashMap<String, TrackManager>();
    private final InvokeTryFinally allInvokeTryFinally;

    public EasyQueryTrackAopConfiguration(ApplicationContext applicationContext) {
        TrackManager trackManager2;
        Map easyQueryClientMap = applicationContext.getBeansOfType(EasyQueryClient.class);
        Map easyQueryMap = applicationContext.getBeansOfType(EasyQuery.class);
        Map easyProxyQueryMap = applicationContext.getBeansOfType(EasyProxyQuery.class);
        LinkedHashSet<TrackManager> distinct = new LinkedHashSet<TrackManager>();
        for (Map.Entry easyQueryClientEntry : easyQueryClientMap.entrySet()) {
            trackManager2 = ((EasyQueryClient)easyQueryClientEntry.getValue()).getRuntimeContext().getTrackManager();
            distinct.add(trackManager2);
            this.trackManagerMap.put((String)easyQueryClientEntry.getKey(), trackManager2);
        }
        for (Map.Entry easyQueryEntry : easyQueryMap.entrySet()) {
            trackManager2 = ((EasyQuery)easyQueryEntry.getValue()).getRuntimeContext().getTrackManager();
            distinct.add(trackManager2);
            this.trackManagerMap.put((String)easyQueryEntry.getKey(), trackManager2);
        }
        for (Map.Entry easyProxyQueryEntry : easyProxyQueryMap.entrySet()) {
            trackManager2 = ((EasyProxyQuery)easyProxyQueryEntry.getValue()).getRuntimeContext().getTrackManager();
            distinct.add(trackManager2);
            this.trackManagerMap.put((String)easyProxyQueryEntry.getKey(), trackManager2);
        }
        InvokeTryFinally invokeTryFinally = EmptyInvokeTryFinally.EMPTY;
        for (TrackManager trackManager2 : distinct) {
            invokeTryFinally = new EasyQueryTrackInvoker(invokeTryFinally, (InvokeTryFinally)trackManager2);
        }
        this.allInvokeTryFinally = invokeTryFinally;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(public * *(..)) && @annotation(com.easy.query.core.annotation.EasyQueryTrack)")
    public Object easyQueryTrack(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        EasyQueryTrack easyQueryTrack = method.getAnnotation(EasyQueryTrack.class);
        if (easyQueryTrack != null && easyQueryTrack.enable()) {
            InvokeTryFinally trackInvokeTryFinally = this.getTrackInvokeTryFinally(easyQueryTrack.tag());
            try {
                trackInvokeTryFinally.begin();
                Object object = pjp.proceed();
                return object;
            }
            finally {
                trackInvokeTryFinally.release();
            }
        }
        return pjp.proceed();
    }

    private InvokeTryFinally getTrackInvokeTryFinally(String tag) {
        InvokeTryFinally invokeTryFinally = EmptyInvokeTryFinally.EMPTY;
        if (EasyStringUtil.isBlank((String)tag)) {
            return this.allInvokeTryFinally;
        }
        if (tag.contains(",")) {
            String[] names;
            for (String name : names = tag.split(",")) {
                TrackManager trackManager = this.trackManagerMap.get(name);
                if (trackManager == null) {
                    log.warn("can not be found tag:[" + tag + "],track manager");
                    continue;
                }
                invokeTryFinally = new EasyQueryTrackInvoker(invokeTryFinally, (InvokeTryFinally)trackManager);
            }
            return invokeTryFinally;
        }
        TrackManager trackManager = this.trackManagerMap.get(tag);
        if (trackManager == null) {
            log.warn("can not be found tag:[" + tag + "],track manager");
            return EmptyInvokeTryFinally.EMPTY;
        }
        return new EasyQueryTrackInvoker(invokeTryFinally, (InvokeTryFinally)trackManager);
    }
}

