/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sql.starter.logging;

import com.easy.query.core.logging.Log;
import com.easy.query.sql.starter.logging.Slf4jImpl;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLocationAwareLoggerImpl
implements Log {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"EASYQUERY");
    private static final String FQCN = Slf4jImpl.class.getName();
    private final LocationAwareLogger logger;

    Slf4jLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void error(String s, Throwable e) {
        this.logger.log(MARKER, FQCN, 40, s, null, e);
    }

    public void error(String s) {
        this.logger.log(MARKER, FQCN, 40, s, null, null);
    }

    public void debug(String s) {
        this.logger.log(MARKER, FQCN, 10, s, null, null);
    }

    public void trace(String s) {
        this.logger.log(MARKER, FQCN, 0, s, null, null);
    }

    public void info(String s) {
        this.logger.log(MARKER, FQCN, 20, s, null, null);
    }

    public void warn(String s) {
        this.logger.log(MARKER, FQCN, 30, s, null, null);
    }
}

