/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqllite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumnFuncValueExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SQLiteDateTimePlusSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final long duration;
    private final TimeUnit timeUnit;

    public SQLiteDateTimePlusSQLFunction(List<ColumnExpression> columnExpressions, long duration, TimeUnit timeUnit) {
        this.columnExpressions = columnExpressions;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (EasyCollectionUtil.isEmpty(this.columnExpressions)) {
            throw new IllegalArgumentException("columnExpressions is empty");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(0);
        this.columnExpressions.clear();
        this.columnExpressions.add(columnExpression);
        long millis = this.timeUnit.toMillis(this.duration);
        this.columnExpressions.add((ColumnExpression)new ColumnFuncValueExpressionImpl((Object)millis));
        return "datetime({0},(({1})/1000)||' seconds')";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

