/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqllite.func;

import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncValueExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.List;

public class SQLiteLikeSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final SQLLikeEnum sqlLikeEnum;

    public SQLiteLikeSQLFunction(List<ColumnExpression> columnExpressions, SQLLikeEnum sqlLikeEnum) {
        this.columnExpressions = columnExpressions;
        this.sqlLikeEnum = sqlLikeEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        String valueString;
        ColumnFuncValueExpression columnFuncValueExpression;
        Object value;
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("bank arguments != 1");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(1);
        if (columnExpression instanceof ColumnFuncValueExpression && (value = (columnFuncValueExpression = (ColumnFuncValueExpression)columnExpression).getValue()) != null && (valueString = value.toString()).contains("%")) {
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
                return "INSTR({1},{0}) = 1";
            }
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
                return "INSTR({1},{0}) = LENGTH({0})";
            }
            return "INSTR({1},{0}) > 0";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
            return "{0} LIKE ({1}||'%')";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
            return "{0} LIKE ('%'||{1})";
        }
        return "{0} LIKE ('%'||{1}||'%')";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

