/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqllite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyClassUtil;
import java.util.List;

public class SQLiteCastSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final Class<?> targetClass;

    public SQLiteCastSQLFunction(List<ColumnExpression> columnExpressions, Class<?> targetClass) {
        this.columnExpressions = columnExpressions;
        this.targetClass = targetClass;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        String targetClassName;
        switch (targetClassName = EasyClassUtil.getFullName(this.targetClass)) {
            case "boolean": 
            case "java.lang.Boolean": {
                return "({0} NOT IN ('0','false'))";
            }
            case "char": {
                return "substr(cast({0} as character), 1, 1)";
            }
            case "java.sql.Time": 
            case "java.time.Time": {
                return "time({0})";
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": {
                return "date({0})";
            }
            case "java.sql.Timestamp": 
            case "java.util.Date": 
            case "java.time.LocalDateTime": {
                return "datetime({0})";
            }
            case "java.math.BigDecimal": {
                return "cast({0} as decimal(36,18))";
            }
            case "double": 
            case "float": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return "cast({0} as double)";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "cast({0} as int2)";
            }
            case "short": 
            case "java.lang.Short": {
                return "CAST({0} AS SMALLINT)";
            }
            case "int": 
            case "long": 
            case "java.lang.Integer": 
            case "java.lang.Long": {
                return "CAST({0} AS SIGNED)";
            }
            case "java.util.UUID": {
                return "substr(cast({0} as character), 1, 36)";
            }
            case "java.lang.String": {
                return "cast({0} as character)";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u8f6c\u6362\u51fd\u6570:" + targetClassName);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

