/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqllite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.List;

public class SQLiteJoinSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final boolean distinct;

    public SQLiteJoinSQLFunction(List<ColumnExpression> columnExpressions, boolean distinct) {
        this.columnExpressions = columnExpressions;
        this.distinct = distinct;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("join arguments != 2");
        }
        if (this.distinct) {
            return "GROUP_CONCAT(DISTINCT {1}, {0})";
        }
        return "GROUP_CONCAT({1}, {0})";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

