/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.config;

import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.migration.AbstractDatabaseMigrationProvider;
import com.easy.query.core.migration.ColumnDbTypeResult;
import com.easy.query.core.migration.EntityMigrationMetadata;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.commands.DefaultMigrationCommand;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyDatabaseUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;

public class SQLiteDatabaseMigrationProvider
extends AbstractDatabaseMigrationProvider {
    private static final Map<Class<?>, ColumnDbTypeResult> columnTypeMap = new HashMap();
    private static final Log log = LogFactory.getLog(SQLiteDatabaseMigrationProvider.class);

    public SQLiteDatabaseMigrationProvider(DataSource dataSource, SQLKeyword sqlKeyword) {
        super(dataSource, sqlKeyword);
    }

    public String databaseExistSQL(String databaseName) {
        throw new UnsupportedOperationException("sqlite not support check database exists.");
    }

    public String createDatabaseSQL(String databaseName) {
        throw new UnsupportedOperationException("sqlite not support create database command.");
    }

    public boolean tableExists(String schema, String tableName) {
        ArrayList sqlParameters = new ArrayList();
        List maps = EasyDatabaseUtil.sqlQuery((DataSource)this.dataSource, (String)String.format("select 1 from %s.sqlite_master where type='table' and name='%s'", this.getDatabaseName(), tableName), sqlParameters);
        return EasyCollectionUtil.isNotEmpty((Collection)maps);
    }

    public MigrationCommand renameTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        String sql = "ALTER TABLE " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getOldTableName()) + " RENAME TO " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()) + ";";
        return new DefaultMigrationCommand(entityMetadata, sql);
    }

    public MigrationCommand createTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" ( ");
        for (ColumnMetadata column : entityMetadata.getColumns()) {
            sql.append(newLine).append(this.getQuoteSQLName(column.getName())).append(" ");
            ColumnDbTypeResult columnDbTypeResult = this.getColumnDbType(entityMigrationMetadata, column);
            sql.append(columnDbTypeResult.columnType);
            boolean nullable = this.isNullable(entityMigrationMetadata, column);
            if (nullable) {
                sql.append(" NULL ");
            } else {
                sql.append(" NOT NULL ");
            }
            if (column.isGeneratedKey()) {
                sql.append(" PRIMARY KEY AUTOINCREMENT");
            }
            sql.append(",");
        }
        Collection keyProperties = entityMetadata.getKeyProperties();
        if (EasyCollectionUtil.isNotEmpty((Collection)keyProperties)) {
            sql.append(" ").append(newLine).append(" PRIMARY KEY (");
            int i = keyProperties.size();
            for (String keyProperty : keyProperties) {
                ColumnMetadata keyColumn = entityMetadata.getColumnNotNull(keyProperty);
                sql.append(this.getQuoteSQLName(keyColumn.getName()));
                if (--i > 0) {
                    sql.append(", ");
                    continue;
                }
                sql.append(")");
            }
        } else {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(newLine).append(");");
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    protected ColumnDbTypeResult getColumnDbType0(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        return columnTypeMap.get(columnMetadata.getPropertyType());
    }

    protected MigrationCommand renameColumn(EntityMigrationMetadata entityMigrationMetadata, String renameFrom, ColumnMetadata column) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" RENAME COLUMN ").append(this.getQuoteSQLName(renameFrom)).append(" TO ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = this.getColumnDbType(entityMigrationMetadata, column);
        sql.append(columnDbTypeResult.columnType);
        if (this.isNullable(entityMigrationMetadata, column)) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        sql.append(";");
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    protected MigrationCommand addColumn(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata column) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName())).append(" ADD COLUMN ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = this.getColumnDbType(entityMigrationMetadata, column);
        sql.append(columnDbTypeResult.columnType);
        if (this.isNullable(entityMigrationMetadata, column)) {
            sql.append(" NULL");
        } else {
            sql.append(" NOT NULL");
        }
        sql.append(";");
        return new DefaultMigrationCommand(entityMetadata, sql.toString());
    }

    public MigrationCommand dropTable(EntityMigrationMetadata entityMigrationMetadata) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        return new DefaultMigrationCommand(entityMetadata, "DROP TABLE " + this.getQuoteSQLName(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName()) + ";");
    }

    static {
        columnTypeMap.put(Boolean.TYPE, new ColumnDbTypeResult("boolean", (Object)false));
        columnTypeMap.put(Boolean.class, new ColumnDbTypeResult("boolean", null));
        columnTypeMap.put(Float.TYPE, new ColumnDbTypeResult("float", (Object)Float.valueOf(0.0f)));
        columnTypeMap.put(Float.class, new ColumnDbTypeResult("float", null));
        columnTypeMap.put(Double.TYPE, new ColumnDbTypeResult("double", (Object)0.0));
        columnTypeMap.put(Double.class, new ColumnDbTypeResult("double", null));
        columnTypeMap.put(Short.TYPE, new ColumnDbTypeResult("smallint", (Object)0));
        columnTypeMap.put(Short.class, new ColumnDbTypeResult("smallint", null));
        columnTypeMap.put(Integer.TYPE, new ColumnDbTypeResult("integer", (Object)0));
        columnTypeMap.put(Integer.class, new ColumnDbTypeResult("integer", null));
        columnTypeMap.put(Long.TYPE, new ColumnDbTypeResult("integer", (Object)0L));
        columnTypeMap.put(Long.class, new ColumnDbTypeResult("integer", null));
        columnTypeMap.put(Byte.TYPE, new ColumnDbTypeResult("int2", (Object)0));
        columnTypeMap.put(Byte.class, new ColumnDbTypeResult("int2", null));
        columnTypeMap.put(byte[].class, new ColumnDbTypeResult("blob", (Object)new byte[0]));
        columnTypeMap.put(Byte[].class, new ColumnDbTypeResult("blob", null));
        columnTypeMap.put(BigDecimal.class, new ColumnDbTypeResult("decimal(16,2)", null));
        columnTypeMap.put(LocalDateTime.class, new ColumnDbTypeResult("datetime", null));
        columnTypeMap.put(String.class, new ColumnDbTypeResult("nvarchar(255)", (Object)""));
        columnTypeMap.put(UUID.class, new ColumnDbTypeResult("character(36)", (Object)""));
    }
}

