/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLiteDateTimeFormatSQLFunction
extends AbstractExpressionSQLFunction {
    private final String javaFormat;
    private final List<ColumnExpression> columnExpressions;

    public SQLiteDateTimeFormatSQLFunction(List<ColumnExpression> columnExpressions, String javaFormat) {
        this.columnExpressions = columnExpressions;
        this.javaFormat = javaFormat;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        return this.getSQLSegment();
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }

    public String getSQLSegment() {
        if (this.javaFormat != null) {
            String format;
            switch (format = this.javaFormat) {
                case "yyyy-MM-dd HH:mm:ss": {
                    return "strftime('%Y-%m-%d %H:%M:%S', {0})";
                }
                case "yyyy-MM-dd HH:mm": {
                    return "strftime('%Y-%m-%d %H:%M', {0})";
                }
                case "yyyy-MM-dd HH": {
                    return "strftime('%Y-%m-%d %H',{0})";
                }
                case "yyyy-MM-dd": {
                    return "strftime('%Y-%m-%d', {0})";
                }
                case "yyyy-MM": {
                    return "strftime('%Y-%m', {0})";
                }
                case "yyyyMMddHHmmss": {
                    return "strftime('%Y%m%d%H%M%S', {0})";
                }
                case "yyyyMMddHHmm": {
                    return "strftime('%Y%m%d%H%M', {0})";
                }
                case "yyyyMMddHH": {
                    return "strftime('%Y%m%d%H', {0})";
                }
                case "yyyyMMdd": {
                    return "strftime('%Y%m%d', {0})";
                }
                case "yyyyMM": {
                    return "strftime('%Y%m', {0})";
                }
                case "yyyy": {
                    return "strftime('%Y', {0})";
                }
                case "HH:mm:ss": {
                    return "strftime('%H:%M:%S', {0})";
                }
            }
            format = this.replaceFormat(format);
            String[] argsFinds = new String[]{"%Y", "%m", "%d", "%H", "%M", "%S"};
            String[] argsSpts = format.split("(yy|M|d|H|hh|h|m|s|tt|t)");
            block52: for (int a2 = 0; a2 < argsSpts.length; ++a2) {
                switch (argsSpts[a2]) {
                    case "yy": {
                        argsSpts[a2] = "substr(strftime('%Y', {0}), 3, 2)";
                        continue block52;
                    }
                    case "M": {
                        argsSpts[a2] = "ltrim(strftime('%m', {0}), '0')";
                        continue block52;
                    }
                    case "d": {
                        argsSpts[a2] = "ltrim(strftime('%d', {0}), '0')";
                        continue block52;
                    }
                    case "H": {
                        argsSpts[a2] = "case when substr(strftime('%H', {0}), 1, 1) = '0' then substr(strftime('%H', {0}), 2, 1) else strftime('%H', {0}) end";
                        continue block52;
                    }
                    case "hh": {
                        argsSpts[a2] = "case cast(case when substr(strftime('%H', {0}), 1, 1) = '0' then substr(strftime('%H', {0}), 2, 1) else strftime('%H', {0}) end as smallint) % 12 when 0 then '12' when 1 then '01' when 2 then '02' when 3 then '03' when 4 then '04' when 5 then '05' when 6 then '06' when 7 then '07' when 8 then '08' when 9 then '09' when 10 then '10' when 11 then '11' end";
                        continue block52;
                    }
                    case "h": {
                        argsSpts[a2] = "case cast(case when substr(strftime('%H', {0}), 1, 1) = '0' then substr(strftime('%H', {0}), 2, 1) else strftime('%H', {0}) end as smallint) % 12 when 0 then '12' when 1 then '1' when 2 then '2' when 3 then '3' when 4 then '4' when 5 then '5' when 6 then '6' when 7 then '7' when 8 then '8' when 9 then '9' when 10 then '10' when 11 then '11' end";
                        continue block52;
                    }
                    case "m": {
                        argsSpts[a2] = "case when substr(strftime('%M', {0}), 1, 1) = '0' then substr(strftime('%M', {0}), 2, 1) else strftime('%M', {0}) end";
                        continue block52;
                    }
                    case "s": {
                        argsSpts[a2] = "case when substr(strftime('%S', {0}), 1, 1) = '0' then substr(strftime('%S', {0}), 2, 1) else strftime('%S', {0}) end";
                        continue block52;
                    }
                    case "tt": {
                        argsSpts[a2] = "case when cast(case when substr(strftime('%H', {0}), 1, 1) = '0' then substr(strftime('%H', {0}), 2, 1) else strftime('%H', {0}) end as smallint) >= 12 then 'PM' else 'AM' end";
                        continue block52;
                    }
                    case "t": {
                        argsSpts[a2] = "case when cast(case when substr(strftime('%H', {0}), 1, 1) = '0' then substr(strftime('%H', {0}), 2, 1) else strftime('%H', {0}) end as smallint) >= 12 then 'P' else 'A' end";
                        continue block52;
                    }
                    default: {
                        String argsSptsA = argsSpts[a2];
                        if (argsSptsA.startsWith("'")) {
                            argsSptsA = argsSptsA.substring(1);
                        }
                        if (argsSptsA.endsWith("'")) {
                            argsSptsA = argsSptsA.substring(0, argsSptsA.length() - 1);
                        }
                        argsSpts[a2] = Arrays.stream(argsFinds).anyMatch(argsSptsA::contains) ? "strftime('" + argsSptsA + "', {0})" : "'" + argsSptsA + "'";
                    }
                }
            }
            if (argsSpts.length == 1) {
                format = argsSpts[0];
            } else if (argsSpts.length > 1) {
                format = "(" + String.join((CharSequence)" || ", (CharSequence[])Arrays.stream(argsSpts).filter(a -> !a.equals("''")).toArray(String[]::new)) + ")";
            }
            return format.replace("%_a1", "%m").replace("%_a2", "%d").replace("%_a3", "%H").replace("%_a4", "%M");
        }
        return "strftime('%Y-%m-%d %H:%M:%f',{0})";
    }

    protected String replaceFormat(String format) {
        String pattern = "(yyyy|MM|dd|HH|mm|ss)";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match;
            switch (match = matcher.group(1)) {
                case "yyyy": {
                    matcher.appendReplacement(result, "%Y");
                    break;
                }
                case "MM": {
                    matcher.appendReplacement(result, "%_a1");
                    break;
                }
                case "dd": {
                    matcher.appendReplacement(result, "%_a2");
                    break;
                }
                case "HH": {
                    matcher.appendReplacement(result, "%_a3");
                    break;
                }
                case "mm": {
                    matcher.appendReplacement(result, "%_a4");
                    break;
                }
                case "ss": {
                    matcher.appendReplacement(result, "%S");
                }
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

