/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.expression;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.expression.sql.expression.impl.InsertSQLExpressionImpl;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SQLiteInsertSQLExpression
extends InsertSQLExpressionImpl {
    public SQLiteInsertSQLExpression(EntitySQLExpressionMetadata entitySQLExpressionMetadata, EntityTableSQLExpression table) {
        super(entitySQLExpressionMetadata, table);
    }

    public String toSQL(ToSQLContext toSQLContext) {
        ExpressionContext expressionContext = this.entitySQLExpressionMetadata.getExpressionContext();
        boolean insertOrIgnore = expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE);
        boolean insertOrUpdate = expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE);
        if (!insertOrIgnore && !insertOrUpdate) {
            return super.toSQL(toSQLContext);
        }
        EasySQLExpressionUtil.expressionInvokeRoot((ToSQLContext)toSQLContext);
        QueryRuntimeContext runtimeContext = expressionContext.getRuntimeContext();
        EntityTableSQLExpression easyTableSQLExpression = (EntityTableSQLExpression)this.tables.get(0);
        EntityMetadata entityMetadata = easyTableSQLExpression.getEntityMetadata();
        TableAvailable entityTable = easyTableSQLExpression.getEntityTable();
        String tableName = easyTableSQLExpression.toSQL(toSQLContext);
        if (insertOrUpdate) {
            StringBuilder sql = new StringBuilder("REPLACE INTO ");
            sql.append(tableName).append(" (");
            Iterator iterator = this.columns.getSQLSegments().iterator();
            SQLSegment firstColumn = (SQLSegment)iterator.next();
            sql.append(this.getColumnNameWithOwner(firstColumn, toSQLContext));
            while (iterator.hasNext()) {
                SQLSegment next = (SQLSegment)iterator.next();
                sql.append(",").append(this.getColumnNameWithOwner(next, toSQLContext));
            }
            sql.append(") VALUES (").append(this.columns.toSQL(toSQLContext)).append(")");
            return sql.toString();
        }
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(tableName).append(" (");
        Iterator iterator = this.columns.getSQLSegments().iterator();
        SQLSegment firstColumn = (SQLSegment)iterator.next();
        sql.append(this.getColumnNameWithOwner(firstColumn, toSQLContext));
        while (iterator.hasNext()) {
            SQLSegment next = (SQLSegment)iterator.next();
            sql.append(",").append(this.getColumnNameWithOwner(next, toSQLContext));
        }
        sql.append(") SELECT ").append(this.columns.toSQL(toSQLContext)).append(" WHERE NOT EXISTS(SELECT 1 FROM ").append(tableName).append(" t ").append(" WHERE (");
        Collection keyProperties = entityMetadata.getKeyProperties();
        Collection<String> constraintPropertyNames = this.getConstraintPropertyName(entityMetadata, keyProperties);
        Map<String, InsertUpdateSetColumnSQLSegment> columnsMap = this.getColumnsMap();
        Iterator<String> constraintPropertyIterator = constraintPropertyNames.iterator();
        String firstConstraintProperty = constraintPropertyIterator.next();
        String firstQuoteName = this.getQuoteName(entityTable, runtimeContext, firstConstraintProperty);
        InsertUpdateSetColumnSQLSegment insertUpdateSetColumnSQLSegment = columnsMap.get(firstConstraintProperty);
        if (insertUpdateSetColumnSQLSegment == null) {
            throw new EasyQueryInvalidOperationException("insert not support:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE.name() + ",constraint column name:" + firstConstraintProperty);
        }
        String parameter = insertUpdateSetColumnSQLSegment.toSQL(toSQLContext);
        sql.append("t.").append(firstQuoteName).append(" = ").append(parameter);
        while (constraintPropertyIterator.hasNext()) {
            String nextConstraintProperty = constraintPropertyIterator.next();
            String quoteName = this.getQuoteName(entityTable, runtimeContext, nextConstraintProperty);
            InsertUpdateSetColumnSQLSegment nextInsertUpdateSetColumnSQLSegment = columnsMap.get(nextConstraintProperty);
            if (nextInsertUpdateSetColumnSQLSegment == null) {
                throw new EasyQueryInvalidOperationException("insert not support:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE.name() + ",constraint column name:" + nextConstraintProperty);
            }
            String nextParameter = nextInsertUpdateSetColumnSQLSegment.toSQL(toSQLContext);
            sql.append(" AND t.").append(quoteName).append(" = ").append(nextParameter);
        }
        sql.append(")").append(")");
        return sql.toString();
    }

    private Map<String, InsertUpdateSetColumnSQLSegment> getColumnsMap() {
        HashMap<String, InsertUpdateSetColumnSQLSegment> columnsMap = new HashMap<String, InsertUpdateSetColumnSQLSegment>();
        for (SQLSegment sqlSegment : this.columns.getSQLSegments()) {
            if (!(sqlSegment instanceof InsertUpdateSetColumnSQLSegment)) {
                throw new EasyQueryInvalidOperationException("insert not support:" + EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE.name() + ",column type:" + EasyClassUtil.getSimpleName(sqlSegment.getClass()));
            }
            InsertUpdateSetColumnSQLSegment sqlEntitySegment = (InsertUpdateSetColumnSQLSegment)sqlSegment;
            columnsMap.put(sqlEntitySegment.getPropertyName(), sqlEntitySegment);
        }
        return columnsMap;
    }

    protected Collection<String> getConstraintPropertyName(EntityMetadata entityMetadata, Collection<String> keyProperties) {
        if (EasyCollectionUtil.isEmpty((Collection)this.duplicateKeys)) {
            return this.getConstraintPropertyName0(entityMetadata, keyProperties);
        }
        return this.getConstraintPropertyName0(entityMetadata, this.duplicateKeys);
    }

    private Collection<String> getConstraintPropertyName0(EntityMetadata entityMetadata, Collection<String> columns) {
        Set<String> constraintKeys = columns.stream().filter(o -> !entityMetadata.getColumnNotNull(o).isGeneratedKey()).collect(Collectors.toSet());
        if (EasyCollectionUtil.isEmpty(constraintKeys)) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName((Class)entityMetadata.getEntityClass()) + " no constraint property");
        }
        return constraintKeys;
    }

    private String getQuoteName(TableAvailable entityTable, QueryRuntimeContext runtimeContext, String constraintProperty) {
        String keyColumnName = entityTable.getColumnName(constraintProperty);
        return EasySQLExpressionUtil.getQuoteName((QueryRuntimeContext)runtimeContext, (String)keyColumnName);
    }
}

