/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class SQLiteJSONObjectFieldSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;

    public SQLiteJSONObjectFieldSQLFunction(List<ColumnExpression> concatExpressions) {
        if (EasyCollectionUtil.isEmpty(concatExpressions)) {
            throw new IllegalArgumentException("SQLiteJSONObjectFieldSQLFunction columns empty");
        }
        this.columnExpressions = concatExpressions;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        List<ColumnExpression> jsonKeyExpressions = this.columnExpressions.subList(1, this.columnExpressions.size());
        List params = EasyCollectionUtil.select(jsonKeyExpressions, (t, i) -> "{" + i + 1 + "}");
        return String.format("JSON_EXTRACT({0}, '$.%s')", String.join((CharSequence)".", params));
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

