/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.func;

import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncValueExpression;
import com.easy.query.core.func.def.impl.AbstractLikeSQLFunction;
import java.util.List;

public class SQLiteLikeSQLFunction
extends AbstractLikeSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final SQLLikeEnum sqlLikeEnum;

    public SQLiteLikeSQLFunction(List<ColumnExpression> columnExpressions, SQLLikeEnum sqlLikeEnum) {
        this.columnExpressions = columnExpressions;
        this.sqlLikeEnum = sqlLikeEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        String valueString;
        Object value;
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("bank arguments != 1");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(1);
        ColumnFuncValueExpression columnFuncValueExpression = this.getColumnFuncValueExpression(columnExpression);
        if (columnFuncValueExpression != null && (value = columnFuncValueExpression.getValue()) instanceof String && ((valueString = (String)value).contains("%") || valueString.contains("_"))) {
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
                return "INSTR({0},{1}) = 1";
            }
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
                return "INSTR({0},{1}) = (LENGTH({0}) - LENGTH({1}) + 1)";
            }
            return "INSTR({0},{1}) > 0";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
            return "{0} LIKE ({1}||'%')";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
            return "{0} LIKE ('%'||{1})";
        }
        return "{0} LIKE ('%'||{1}||'%')";
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

