/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.algorithm;

public class Levenshtein {
    private static int compare(String str, String target) {
        int j;
        int i;
        int n = str.length();
        int m = target.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char ch1 = str.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char ch2 = target.charAt(j - 1);
                int temp = ch1 == ch2 ? 0 : 1;
                d[i][j] = Levenshtein.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + temp);
            }
        }
        return d[n][m];
    }

    private static int min(int one, int two, int three) {
        one = one < two ? one : two;
        return one < three ? one : three;
    }

    public static float getSimilarityRatio(String str, String target) {
        return 1.0f - (float)Levenshtein.compare(str, target) / (float)Math.max(str.length(), target.length());
    }

    public static void main(String[] args) {
        String str = "af\u8303\u5fb7\u8428\u6076\u5316\u4e0e\u4f1a\u5458\u4ef7 ";
        String target = "a\u4ef7\u5458\u4f1a\u4e0e\u5316\u6076\u8428\u5fb7\u8303af\u4f1a\u5458\u4ef7";
        System.out.println("similarityRatio=" + Levenshtein.getSimilarityRatio(str, target));
    }
}

