/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.algorithm;

import java.util.Date;

public class RC4Utils {
    private byte[] state = new byte[256];
    private int x;
    private int y;

    public RC4Utils(String key) throws NullPointerException {
        this(key.getBytes());
    }

    public RC4Utils(byte[] key) throws NullPointerException {
        for (int i = 0; i < 256; ++i) {
            this.state[i] = (byte)i;
        }
        this.x = 0;
        this.y = 0;
        int index1 = 0;
        int index2 = 0;
        if (key == null || key.length == 0) {
            throw new NullPointerException();
        }
        for (int i = 0; i < 256; ++i) {
            index2 = (key[index1] & 0xFF) + (this.state[i] & 0xFF) + index2 & 0xFF;
            byte tmp = this.state[i];
            this.state[i] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % key.length;
        }
    }

    public byte[] rc4(String data) {
        if (data == null) {
            return null;
        }
        byte[] tmp = data.getBytes();
        this.rc4(tmp);
        return tmp;
    }

    public byte[] rc4(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] result = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = (this.state[this.x] & 0xFF) + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            int xorIndex = (this.state[this.x] & 0xFF) + (this.state[this.y] & 0xFF) & 0xFF;
            result[i] = (byte)(buf[i] ^ this.state[xorIndex]);
        }
        return result;
    }

    public static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("length is wrong!");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        b = null;
        return b2;
    }

    public static String byteToString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int d = bytes[i];
            if (d < 0) {
                d += 256;
            }
            if (d < 16) {
                buf.append("0");
            }
            buf.append(Integer.toString(d, 16));
        }
        return buf.toString();
    }

    public static String encrypt(String val, String key) {
        if (val == null) {
            throw new NullPointerException();
        }
        return RC4Utils.byteToString(new RC4Utils(key).rc4(val.getBytes()));
    }

    public static String decrypt(String val, String key) {
        if (val == null) {
            throw new NullPointerException();
        }
        RC4Utils rc = new RC4Utils(key);
        byte[] ts = RC4Utils.hex2byte(val.getBytes());
        return new String(rc.rc4(ts));
    }

    public static void main(String[] args) {
        System.out.println(RC4Utils.encrypt(new Date().getTime() + "", "key"));
        System.out.println(RC4Utils.decrypt("4cc11bef1829f3f080ebf2ef83f90956393ad53a3ffdae24a2f303207bc28aa31600559a2993dd870bb77d27bd176d7e25b8", "key"));
    }
}

