/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.cache;

import com.easycodebox.common.cache.CacheOperation;
import com.easycodebox.common.cache.Cacheable;
import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;

@Aspect
@Deprecated
public final class CacheAspect
implements Ordered,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CacheAspect.class);
    private final Integer DEFAULT_ORDER = 100;
    private Integer order;
    private CacheManager cacheManager;
    private Resource configLocation;
    private boolean shared = false;
    private String cacheManagerName;
    private int maxElementsInMemory = 10000;
    private int maxElementsOnDisk = 10000000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    private boolean overflowToDisk = true;
    private boolean eternal = false;
    private int timeToLive = 600;
    private int timeToIdle = 300;
    private boolean diskPersistent = false;
    private int diskExpiryThreadIntervalSeconds = 120;

    public void destroy() {
        LOG.info("Shutting down Cache CacheManager");
        this.cacheManager.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        Integer n = this.order = this.order == null ? this.DEFAULT_ORDER : this.order;
        if (this.cacheManager != null) {
            LOG.info("Cache CacheManager had been Initialized");
            return;
        }
        LOG.info("Initializing Cache CacheManager");
        if (this.shared) {
            if (this.configLocation != null) {
                try {
                    this.cacheManager = CacheManager.create((InputStream)this.configLocation.getInputStream());
                }
                catch (Exception e) {
                    LOG.error((Object)"load resource error.", e);
                    this.cacheManager = CacheManager.create();
                }
            } else {
                this.cacheManager = CacheManager.create();
            }
        } else if (this.configLocation != null) {
            try {
                this.cacheManager = new CacheManager(this.configLocation.getInputStream());
            }
            catch (Exception e) {
                LOG.error((Object)"load resource error.", e);
                this.cacheManager = new CacheManager();
            }
        } else {
            this.cacheManager = new CacheManager();
        }
        if (this.cacheManagerName != null) {
            this.cacheManager.setName(this.cacheManagerName);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @Around(value="@annotation(cacheable)")
    public Object cacheable(ProceedingJoinPoint pjp, Cacheable cacheable) throws Throwable {
        if (cacheable.cacheOperation() == CacheOperation.NOP) {
            return pjp.proceed();
        }
        String group = cacheable.group().getName();
        String cacheKey = this.getCacheKey(pjp);
        Cache cache = this.getCache(group);
        Object result = null;
        if (cacheable.cacheOperation() == CacheOperation.CACHING) {
            Element element = cache.get((Serializable)((Object)cacheKey));
            if (element == null) {
                result = pjp.proceed();
                if (result == null || result instanceof Serializable) {
                    element = new Element((Serializable)((Object)cacheKey), (Serializable)result);
                    LOG.info((Object)"\u6b63\u5728\u7f13\u5b58{0}\u5bf9\u8c61\u3002", cacheKey);
                    cache.putIfAbsent(element);
                } else {
                    LOG.warn((Object)"{0}\u6307\u5b9a\u65b9\u6cd5\u8fd4\u56de\u5bf9\u8c61{1}\u4e0d\u80fd\u88ab\u5e8f\u5217\u5316\uff0c\u4e0d\u80fd\u7f13\u5b58\u3002", cacheKey, result);
                }
            } else {
                LOG.info((Object)"\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6{0}\u5bf9\u8c61\u3002", cacheKey);
                result = element.getObjectValue();
            }
        } else if (cacheable.cacheOperation() == CacheOperation.FLUSH_CACHE) {
            result = pjp.proceed();
            for (Class<?> clazz : cacheable.flushGroup()) {
                String groupName = clazz.getName();
                if (groupName.equals(group)) continue;
                LOG.info((Object)"\u5220\u9664\u7f13\u5b58\u7ec4{0}\u6240\u6709\u7684\u7f13\u5b58\u5bf9\u8c61\u3002", groupName);
                this.getCache(group).removeAll();
            }
            LOG.info((Object)"\u5220\u9664\u7f13\u5b58\u7ec4{0}\u6240\u6709\u7684\u7f13\u5b58\u5bf9\u8c61\u3002", group);
            cache.removeAll();
        }
        return result;
    }

    private String getCacheKey(ProceedingJoinPoint pjp) {
        StringBuilder sb = new StringBuilder();
        sb.append(pjp.getTarget().getClass().getName()).append(".").append(pjp.getSignature().getName());
        Object[] arguments = pjp.getArgs();
        if (arguments != null && arguments.length > 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".");
                Object arg = arguments[i];
                if (arg instanceof DetailEnum) {
                    sb.append(((DetailEnum)arg).getClassName());
                    continue;
                }
                sb.append(arg);
            }
        }
        return sb.toString();
    }

    private Cache getCache(String group) {
        if (this.cacheManager == null) {
            this.cacheManager = CacheManager.getInstance();
        }
        Cache cache = null;
        if (this.cacheManager.cacheExists(group)) {
            LOG.debug((Object)"\u83b7\u53d6\u7f13\u5b58\u7ec4{0}\u5bf9\u8c61\u3002", group);
            cache = this.cacheManager.getCache(group);
        }
        if (cache == null) {
            LOG.debug((Object)"\u521b\u5efa\u7f13\u5b58\u7ec4{0}\u5bf9\u8c61\u3002", group);
            cache = this.createCache(group);
            Cache back = (Cache)this.cacheManager.addCacheIfAbsent((Ehcache)cache);
            cache = back == null ? cache : back;
        }
        return cache;
    }

    private Cache createCache(String group) {
        return new Cache(group, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, null, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null, null, this.maxElementsOnDisk);
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToIdle(int timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }
}

