/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.cache.spring;

import com.easycodebox.common.cache.spring.MultiKey;
import com.easycodebox.common.cache.spring.MultiMode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.cache.interceptor.KeyGenerator;

public class MultiKeyGenerator
implements KeyGenerator {
    private ConcurrentHashMap<String, Integer> multiKeyIndexMap = new ConcurrentHashMap(16);
    private final Integer NON_MULTI_KEY_ANNO = NumberUtils.INTEGER_MINUS_ONE;

    public Object generate(Object target, Method method, Object ... params) {
        Object[] ps;
        String mKey = this.genetateMethodKey(target, method);
        if (!this.multiKeyIndexMap.containsKey(mKey)) {
            this.multiKeyIndexMap.putIfAbsent(mKey, this.lookupMultiIndex(target, method));
        }
        if (this.multiKeyIndexMap.get(mKey).equals(this.NON_MULTI_KEY_ANNO)) {
            for (Object param : params) {
                if (param.getClass().isArray()) {
                    return new MultiKey((Object[])param);
                }
                if (!(param instanceof Collection)) continue;
                return new MultiKey(((Collection)param).toArray());
            }
            throw new IllegalArgumentException("There is no param is Array or Collection in method(" + method.getName() + ").");
        }
        Object param = params[this.multiKeyIndexMap.get(mKey)];
        if (param.getClass().isArray()) {
            ps = (Object[])param;
        } else if (param instanceof Collection) {
            ps = ((Collection)param).toArray();
        } else {
            throw new IllegalArgumentException("The param with @MultiMode in method(" + method.getName() + ") is not Array or Collection.");
        }
        return new MultiKey(ps);
    }

    private String genetateMethodKey(Object target, Method method) {
        return target.getClass().getName().concat(".").concat(method.getName());
    }

    private Integer lookupMultiIndex(Object target, Method method) {
        Integer index = this.NON_MULTI_KEY_ANNO;
        Annotation[][] as = method.getParameterAnnotations();
        for (int i = 0; i < as.length; ++i) {
            for (Annotation anno : as[i]) {
                if (!(anno instanceof MultiMode)) continue;
                return i;
            }
        }
        if (target != null) {
            try {
                index = this.lookupMultiIndex(null, target.getClass().getMethod(method.getName(), method.getParameterTypes()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return index;
    }
}

