/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.cache.spring.ehcache;

import com.easycodebox.common.cache.spring.ehcache.CustomEhCacheCache;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;

public class EhCacheDynamicCacheManager
extends EhCacheCacheManager {
    private CacheConfiguration stdEhcacheCfg;

    protected Collection<Cache> loadCaches() {
        Status status = this.getCacheManager().getStatus();
        if (!Status.STATUS_ALIVE.equals(status)) {
            throw new IllegalStateException("An 'alive' EhCache CacheManager is required - current cache is " + status.toString());
        }
        String[] names = this.getCacheManager().getCacheNames();
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(names.length);
        for (String name : names) {
            caches.add((Cache)new CustomEhCacheCache(this.getCacheManager().getEhcache(name)));
        }
        return caches;
    }

    protected Cache getMissingCache(String name) {
        Ehcache ehcache = this.getCacheManager().getEhcache(name);
        if (ehcache != null) {
            return new CustomEhCacheCache(ehcache);
        }
        if (this.stdEhcacheCfg == null) {
            this.getCacheManager().addCacheIfAbsent(name);
            return new CustomEhCacheCache(this.getCacheManager().getEhcache(name));
        }
        net.sf.ehcache.Cache cache = new net.sf.ehcache.Cache(this.stdEhcacheCfg.clone().name(name));
        this.getCacheManager().addCacheIfAbsent((Ehcache)cache);
        return new CustomEhCacheCache((Ehcache)cache);
    }

    public CacheConfiguration getStdEhcacheCfg() {
        return this.stdEhcacheCfg;
    }

    public void setStdEhcacheCfg(CacheConfiguration stdEhcacheCfg) {
        this.stdEhcacheCfg = stdEhcacheCfg;
    }
}

