/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.command;

import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.IOUtils;

public abstract class RuntimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeUtils.class);

    public static int exec(String cmd) throws Exception {
        return RuntimeUtils.exec(cmd, null, null);
    }

    public static int exec(String cmd, StreamHandler handler) throws Exception {
        return RuntimeUtils.exec(cmd, handler, handler);
    }

    public static int exec(String cmd, StreamHandler out, StreamHandler err) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd);
        StreamConsumer outConsumer = null;
        if (out != null) {
            outConsumer = new StreamConsumer(proc.getInputStream(), out);
            outConsumer.start();
        }
        Thread errConsumer = null;
        if (err != null) {
            errConsumer = new StreamConsumer(proc.getErrorStream(), err);
            errConsumer.start();
        }
        if (outConsumer != null) {
            outConsumer.join();
        }
        if (errConsumer != null) {
            errConsumer.join();
        }
        int r = proc.waitFor();
        RuntimeUtils.destroyQuietly(proc);
        return r;
    }

    public static void destroyQuietly(Process process) {
        if (process == null) {
            return;
        }
        try {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
            process.destroy();
        }
        catch (Exception e) {
            LOG.warn((Object)"failed to destroy process", e);
        }
    }

    public static void main(String[] args) {
        try {
            StreamHandler out = new StreamHandler(){

                @Override
                public String getEncoding() {
                    return "ISO-2022-JP";
                }

                @Override
                public void onReadLine(String line) throws IOException {
                    System.out.println(line);
                }
            };
            StreamHandler err = new StreamHandler(){

                @Override
                public String getEncoding() {
                    return "ISO-2022-JP";
                }

                @Override
                public void onReadLine(String line) throws IOException {
                    System.err.println(line);
                }
            };
            System.out.println(RuntimeUtils.exec("java -version", out, err));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface StreamHandler {
        public String getEncoding();

        public void onReadLine(String var1) throws IOException;
    }

    private static class StreamConsumer
    extends Thread {
        private InputStream is;
        private StreamHandler handler;

        public StreamConsumer(InputStream is, StreamHandler handler) {
            this.is = is;
            this.handler = handler;
        }

        @Override
        public void run() {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.is, this.handler.getEncoding()));
                while ((line = reader.readLine()) != null) {
                    this.handler.onReadLine(line);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"unhandled exception in stream consumer", e);
            }
        }
    }
}

