/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.enums;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.file.Resources;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;

public class EnumClassFactory
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EnumClassFactory.class);
    private static Map<String, Class<? extends Enum<?>>> enums = new ConcurrentHashMap();
    private Class<? extends Enum<?>>[] annotatedClasses;
    private String[] packagesToScan;

    public static Class<? extends Enum<?>> newInstance(String enumName) {
        return enums.get(enumName.toUpperCase());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.annotatedClasses != null && this.annotatedClasses.length > 0) {
            for (Class<? extends Enum<?>> clazz : this.annotatedClasses) {
                this.addEnum(clazz);
                LOG.debug((Object)"load enum class {0}", clazz);
            }
        }
        List<Class<?>> classes = Resources.scanClass(this.packagesToScan);
        for (Class<?> clazz : classes) {
            if (!Enum.class.isAssignableFrom(clazz)) continue;
            this.addEnum(clazz);
            LOG.debug((Object)"load enum class {0}", clazz);
        }
    }

    private void addEnum(Class<? extends Enum<?>> clazz) {
        String key = clazz.getSimpleName().toUpperCase();
        if (enums.containsKey(key)) {
            throw new BaseException("Enum key {0} already exists.Do not repeat to add.", key);
        }
        enums.put(key, clazz);
    }

    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedClasses(Class<? extends Enum<?>>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }
}

