/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.enums;

import com.easycodebox.common.enums.DetailEnum;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.lang.reflect.Method;

public final class Enums {
    private static final Logger LOG = LoggerFactory.getLogger(Enums.class);

    public static <T extends Enum<T>, V> T parse(Class<T> clazz, V value) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (((DetailEnum)((Object)t)).getValue() == null && value == null) {
                return (T)t;
            }
            if (((DetailEnum)((Object)t)).getValue() == null || value == null || !((DetailEnum)((Object)t)).getValue().equals(value)) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Enum<T>, V> String getEnum(Class<T> clz) {
        try {
            Method values = clz.getDeclaredMethod("values", new Class[0]);
            DetailEnum[] v = (DetailEnum[])values.invoke(clz, new Object[0]);
            return Enums.getEnum(v);
        }
        catch (Exception e) {
            LOG.error((Object)clz.getSimpleName(), e);
            return "";
        }
    }

    public static String getEnum(DetailEnum<?>[] pe) {
        StringBuilder sb = new StringBuilder();
        for (DetailEnum<?> item : pe) {
            sb.append("\"").append(item.getValue()).append("\":\"").append(item.getDesc()).append("\",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static <T> T deserialize(Class<T> enumType, String value, boolean enableOrdinal) {
        DetailEnum data = null;
        try {
            data = (DetailEnum)Enum.valueOf(enumType, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data == null) {
            if (DetailEnum.class.isAssignableFrom(enumType)) {
                for (DetailEnum e : (DetailEnum[])enumType.getEnumConstants()) {
                    if ((e.getValue() != null || value != null) && (value == null || !value.equalsIgnoreCase(e.getValue().toString()))) continue;
                    data = e;
                    break;
                }
                if (data == null) {
                    for (DetailEnum e : (DetailEnum[])enumType.getEnumConstants()) {
                        if ((e.getDesc() != null || value != null) && (value == null || !value.equalsIgnoreCase(e.getDesc().toString()))) continue;
                        data = e;
                        break;
                    }
                }
            }
            if (data == null && enableOrdinal) {
                try {
                    int index = Integer.parseInt(value);
                    for (T e : enumType.getEnumConstants()) {
                        if (((Enum)e).ordinal() != index) continue;
                        data = e;
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return (T)data;
    }
}

