/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.error;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.file.PropertiesPool;
import com.easycodebox.common.jackson.CodeMsgSerializer;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;

@JsonSerialize(using=CodeMsgSerializer.class)
public class CodeMsg
implements Serializable {
    private static final long serialVersionUID = -3878661816244443335L;
    public static CodeMsg NONE = new CodeMsg(null, null);
    public static CodeMsg SUC = new CodeMsg(Code.SUC_CODE, null);
    public static CodeMsg SUC_MSG = new CodeMsg(Code.SUC_CODE, Msg.SUC_MSG_INFO);
    public static CodeMsg FAIL = new CodeMsg(Code.FAIL_CODE, null);
    public static CodeMsg FAIL_MSG = new CodeMsg(Code.FAIL_CODE, Msg.FAIL_MSG_INFO);
    public static CodeMsg NO_LOGIN = new CodeMsg(Code.NO_LOGIN_CODE, null);
    private String code;
    private String msg;
    private Object data;

    protected CodeMsg(String code, String msg) {
        this(code, msg, null);
    }

    protected CodeMsg(String code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public CodeMsg code(String code) {
        CodeMsg codeMsg = this.copy();
        codeMsg.code = code;
        return codeMsg;
    }

    public CodeMsg msg(String msg, Object ... args) {
        CodeMsg codeMsg = this.copy();
        codeMsg.msg = StringUtils.format(msg, args);
        return codeMsg;
    }

    public CodeMsg codeMsg(String code, String msg, Object ... args) {
        CodeMsg codeMsg = this.copy();
        codeMsg.code = code;
        codeMsg.msg = StringUtils.format(msg, args);
        return codeMsg;
    }

    public CodeMsg fillArgs(Object ... args) {
        if (args != null && args.length > 0) {
            return this.msg(this.getMsg(), args);
        }
        return this;
    }

    public CodeMsg data(Object data) {
        CodeMsg codeMsg = this.copy();
        codeMsg.data = data;
        return codeMsg;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        if (this.msg == null && this.getCode() != null) {
            String propertyVal;
            this.msg = propertyVal = PropertiesPool.getProperty(this.getCode());
        }
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        try {
            return Jacksons.COMMUNICATE.toJson(this);
        }
        catch (JsonProcessingException e) {
            throw new BaseException("Transform BaseCodeMsg obj to JSON error.", (Throwable)e, new Object[0]);
        }
    }

    public CodeMsg copy() {
        return new CodeMsg(this.getCode(), this.getMsg(), this.getData());
    }

    public boolean isSuc() {
        return this.getCode() == null || Code.SUC_CODE.equals(this.getCode());
    }

    public static class CodeMsgUtils {
        public static CodeMsg json2Bean(String json) throws JsonProcessingException, IOException {
            Map map = (Map)Jacksons.COMMUNICATE.readValue(json, Map.class);
            String code = (String)map.get("code");
            String msg = (String)map.get("msg");
            Object data = map.get("data");
            return new CodeMsg(code, msg, data);
        }

        public static CodeMsg json2Bean(String json, Class<?> dataValueType) throws JsonProcessingException, IOException {
            return CodeMsgUtils.json2Bean(json, dataValueType == null ? null : Jacksons.COMMUNICATE.getTypeFactory().constructType(dataValueType));
        }

        public static CodeMsg json2Bean(String json, TypeReference<?> dataValueTypeRef) throws JsonProcessingException, IOException {
            return CodeMsgUtils.json2Bean(json, dataValueTypeRef == null ? null : Jacksons.COMMUNICATE.getTypeFactory().constructType(dataValueTypeRef));
        }

        public static CodeMsg json2Bean(String json, JavaType dataValueType) throws JsonProcessingException, IOException {
            if (dataValueType == null) {
                return CodeMsgUtils.json2Bean(json);
            }
            JsonNode jsonNode = Jacksons.COMMUNICATE.readTree(json);
            String code = jsonNode.get("code").asText();
            String msg = jsonNode.get("msg").asText();
            Object data = null;
            JsonNode dataNode = jsonNode.get("data");
            if (!dataNode.isNull()) {
                data = Jacksons.COMMUNICATE.readValue(Jacksons.COMMUNICATE.treeAsTokens((TreeNode)dataNode), dataValueType);
            }
            return new CodeMsg(code, msg, data);
        }

        public static void storePropertiesFile(Class<? extends CodeMsg> clazz, File propertiesFile) throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, IOException {
            Object[] excludeCodes = new String[]{Code.SUC_CODE, Code.FAIL_CODE, Code.NO_LOGIN_CODE};
            Properties p = new Properties(){
                private static final long serialVersionUID = 2380710761701073981L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    TreeSet<Object> set = new TreeSet<Object>(new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            int len2;
                            String str1 = o1.toString();
                            String str2 = o2.toString();
                            int len1 = str1.length();
                            return len1 == (len2 = str2.length()) ? str1.compareTo(str2) : len1 - len2;
                        }
                    });
                    set.addAll(this.keySet());
                    return Collections.enumeration(set);
                }
            };
            for (Field f : clazz.getFields()) {
                CodeMsg code;
                if (!Modifier.isStatic(f.getModifiers()) || !CodeMsg.class.isAssignableFrom(f.getType()) || (code = (CodeMsg)f.get(clazz)).getCode() == null || code.getMsg() == null || ArrayUtils.contains((Object[])excludeCodes, (Object)code.getCode())) continue;
                p.put(code.getCode(), code.getMsg());
            }
            p.store(new FileOutputStream(propertiesFile), "code msg.");
        }
    }

    public static class Msg {
        public static String SUC_MSG_INFO = "\u64cd\u4f5c\u6210\u529f";
        public static String FAIL_MSG_INFO = "\u64cd\u4f5c\u5931\u8d25";
    }

    public static class Code {
        public static final String SUC_CODE = BaseConstants.codeSuc;
        public static final String FAIL_CODE = BaseConstants.codeFail;
        public static final String NO_LOGIN_CODE = BaseConstants.codeNoLogin;
    }
}

