/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.error;

import com.easycodebox.common.enums.entity.LogLevel;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.filter.LogLevelException;

public class ErrorContext
extends LogLevelException {
    private static final long serialVersionUID = 1053969252838403620L;
    private static final ThreadLocal<ErrorContext> LOCAL = new ThreadLocal();
    private CodeMsg error;

    protected ErrorContext(CodeMsg error, Throwable cause) {
        super(error == null ? null : error.getMsg(), cause);
        this.error = error;
    }

    public static ErrorContext instance() {
        return ErrorContext.instance((CodeMsg)null, (Throwable)null, new Object[0]);
    }

    public static ErrorContext instance(String msg, Object ... args) {
        return ErrorContext.instance(CodeMsg.Code.FAIL_CODE, msg, args);
    }

    public static ErrorContext instance(String code, String msg, Object ... args) {
        return ErrorContext.instance(CodeMsg.NONE.codeMsg(code, msg, args), new Object[0]);
    }

    public static ErrorContext instance(CodeMsg error, Object ... args) {
        return ErrorContext.instance(error, (Throwable)null, args);
    }

    public static ErrorContext instance(CodeMsg error, Throwable cause, Object ... args) {
        ErrorContext errorContext = LOCAL.get();
        if (errorContext == null) {
            errorContext = new ErrorContext(error == null ? error : error.fillArgs(args), cause);
            LOCAL.set(errorContext);
        }
        return errorContext;
    }

    public static boolean hasError() {
        return LOCAL.get() != null;
    }

    public ErrorContext error(CodeMsg error) {
        this.error = error;
        return this;
    }

    public ErrorContext logLevel(LogLevel logLevel) {
        this.getLogLevelConfig().setLogLevel(logLevel);
        return this;
    }

    @Override
    public ErrorContext reset() {
        super.reset();
        this.error = null;
        LOCAL.remove();
        return this;
    }

    public CodeMsg getError() {
        return this.error;
    }
}

