/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.file.FileType;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

@Deprecated
public class FileTypes {
    private static final Logger LOG = LoggerFactory.getLogger(FileTypes.class);

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static FileType getFileType(String filePath) {
        if (filePath == null) {
            return null;
        }
        return FileTypes.getFileType(new File(filePath));
    }

    public static FileType getFileType(File file) {
        if (file == null) {
            return null;
        }
        try {
            return FileTypes.getFileType(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"FileNotFoundException", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileType getFileType(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] b = new byte[10];
            inputStream.read(b, 0, b.length);
            String fileCode = FileTypes.bytesToHexString(b);
            if (fileCode == null) {
                FileType fileType = null;
                return fileType;
            }
            fileCode = fileCode.toUpperCase();
            FileType[] types = FileType.values();
            for (int i = 0; i < types.length; ++i) {
                if (!fileCode.startsWith(types[i].getValue())) continue;
                FileType fileType = types[i];
                return fileType;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"IOException", e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getImageFileType(File file) {
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                String string2 = null;
                return string2;
            }
            ImageReader reader = iter.next();
            String string = reader.getFormatName();
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        FileTypes.testShowFileType(new File("D:\\back\\upload"));
        System.out.println("time ===" + (System.currentTimeMillis() - time));
    }

    private static void testShowFileType(File file) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                FileTypes.testShowFileType(fs[i]);
            }
        } else {
            System.out.println(FileTypes.getFileType(file));
        }
    }
}

