/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.file.FileInfo;
import com.easycodebox.common.file.Image;
import com.easycodebox.common.file.ImageTools;
import com.easycodebox.common.file.MimeTypes;
import com.easycodebox.common.file.exception.NonEnlargedException;
import com.easycodebox.common.lang.DecimalUtils;
import com.easycodebox.common.lang.RegularUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTools.class);
    public static final String TMP_PATH = "tmp";

    public static String getAbsolutePathWithClass() {
        File directory = new File("");
        String courseFile = null;
        try {
            courseFile = directory.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error("The method getAbsolutePathWithClass in HttpUtil:" + e.getMessage());
        }
        return courseFile;
    }

    public static void createFile(String fileFullName) throws IOException {
        FileUtils.createFile(fileFullName, false, false);
    }

    public static void createFile(File file) throws IOException {
        FileUtils.createFile(file, false, false);
    }

    public static void createFile(File file, boolean removeFlag, boolean createDir) throws IOException {
        File parent;
        if (file.exists()) {
            if (removeFlag) {
                file.delete();
            } else {
                throw new IOException("\u6587\u4ef6\u5df2\u5b58\u5728");
            }
        }
        if ((parent = file.getParentFile()) != null && !parent.exists() && createDir) {
            parent.mkdirs();
        }
        file.createNewFile();
    }

    public static boolean hasLarger(File[] files, double m) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!(FileUtils.byte2m(f.length(), 6) > m)) continue;
                return true;
            }
        }
        return false;
    }

    public static double byte2m(long data, int digit) {
        return new BigDecimal(1.0 * (double)data / 1024.0 / 1024.0).setScale(digit, 0).doubleValue();
    }

    public static void createFile(String fileFullName, boolean removeFlag, boolean createDir) throws IOException {
        File file = new File(fileFullName);
        FileUtils.createFile(file, removeFlag, createDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(File file, List<String> contentList) throws IOException {
        if (contentList == null || contentList.size() == 0) {
            return;
        }
        if (file == null || !file.exists()) {
            throw new IOException(file + " \u4e0d\u5b58\u5728.");
        }
        String sep = System.getProperty("line.separator");
        try (OutputStreamWriter writer = null;){
            StringBuilder buf = new StringBuilder();
            for (String str : contentList) {
                buf.append(str).append(sep);
            }
            writer = new FileWriter(file, true);
            writer.write(buf.toString().toCharArray());
            writer.flush();
        }
    }

    @Deprecated
    public static Image[] uploadImgs(File[] imgs, String[] imgsFileName, String[] toNames, String baseRealPath, String filePath, boolean returnBigImg, boolean scale, boolean enlarge, boolean createSmallImg) throws Exception {
        if (imgs == null || imgs.length == 0) {
            throw new NullPointerException("imgs is null.");
        }
        if (StringUtils.isBlank((String)baseRealPath)) {
            throw new NullPointerException("arg baseRealPath is blank in (uploadFiles) method.");
        }
        if (StringUtils.isBlank((String)filePath)) {
            throw new NullPointerException("arg filePath is blank in (uploadFiles) method.");
        }
        if (imgsFileName == null || imgsFileName.length != imgs.length) {
            throw new BaseException("arg filesFileName's length is not equeal files in (uploadFiles) method.", new Object[0]);
        }
        Object[] urlAndImgs = FileUtils.analyzeUploadImgUrl(filePath, !createSmallImg, true);
        String url = (String)urlAndImgs[0];
        List smallImgs = urlAndImgs[1] == null ? null : (List)urlAndImgs[1];
        Image[] images = new Image[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            Image[] tmp;
            String fileName = toNames[i] + ".jpg";
            File uploadFile = new File(baseRealPath + "/" + url, fileName);
            org.apache.commons.io.FileUtils.copyFile((File)imgs[i], (File)uploadFile);
            BufferedImage bufImg = ImageIO.read(new FileInputStream(imgs[i]));
            if (smallImgs != null && smallImgs.size() > 0) {
                try {
                    tmp = ImageTools.resizeImage(bufImg, fileName, baseRealPath, scale, enlarge, smallImgs);
                    if (returnBigImg) {
                        images[i] = tmp[tmp.length - 1];
                        continue;
                    }
                    images[i] = tmp[0];
                }
                catch (NonEnlargedException e) {
                    LOG.error((Object)"resizeImage error.", e);
                    Image tmp2 = new Image();
                    tmp2.setError(e.getMessage());
                    tmp2.setWidth(bufImg.getWidth());
                    tmp2.setHeight(bufImg.getHeight());
                    tmp2.setSize(FileUtils.byte2m(uploadFile.length(), 2));
                    tmp2.setName(fileName);
                    images[i] = tmp2;
                }
                continue;
            }
            tmp = new Image();
            tmp.setPath(url);
            tmp.setWidth(bufImg.getWidth());
            tmp.setHeight(bufImg.getHeight());
            tmp.setSize(FileUtils.byte2m(uploadFile.length(), 2));
            tmp.setName(fileName);
            images[i] = tmp;
        }
        return images;
    }

    @Deprecated
    public static Image[] uploadImg(File img, String imgFileName, String toName, String baseRealPath, String filePath, boolean scale, boolean enlarge) throws Exception {
        if (img == null) {
            throw new NullPointerException("img is null.");
        }
        if (StringUtils.isBlank((String)baseRealPath)) {
            throw new NullPointerException("arg baseRealPath is blank.");
        }
        if (StringUtils.isBlank((String)filePath)) {
            throw new NullPointerException("arg filePath is blank.");
        }
        if (imgFileName == null) {
            throw new NullPointerException("imgFileName is null.");
        }
        Object[] urlAndImgs = FileUtils.analyzeUploadImgUrl(filePath, false, true);
        String url = (String)urlAndImgs[0];
        List smallImgs = urlAndImgs[1] == null ? null : (List)urlAndImgs[1];
        String fileName = toName + ".jpg";
        File uploadFile = new File(baseRealPath + "/" + url, fileName);
        org.apache.commons.io.FileUtils.copyFile((File)img, (File)uploadFile);
        BufferedImage bufImg = ImageIO.read(new FileInputStream(img));
        Image bigImg = new Image();
        bigImg.setPath(url);
        bigImg.setWidth(bufImg.getWidth());
        bigImg.setHeight(bufImg.getHeight());
        bigImg.setSize(FileUtils.byte2m(uploadFile.length(), 2));
        if (smallImgs != null && smallImgs.size() > 0) {
            try {
                Image[] tmp = ImageTools.resizeImage(bufImg, fileName, baseRealPath, scale, enlarge, smallImgs);
                Image[] retImgs = new Image[tmp.length + 1];
                retImgs[0] = bigImg;
                for (int j = 0; j < tmp.length; ++j) {
                    retImgs[j + 1] = tmp[j];
                }
                return retImgs;
            }
            catch (NonEnlargedException e) {
                LOG.error((Object)"resizeImage error.", e);
                bigImg.setError(e.getMessage());
            }
        }
        return new Image[]{bigImg};
    }

    public static Object[] analyzeUploadImgUrl(String url, boolean onlyBackUrl, boolean isTmp) {
        Object[] back = new Object[2];
        String[] o = url.split("=");
        back[0] = (isTmp ? "tmp/" : "") + o[0];
        if (!onlyBackUrl && o.length > 1) {
            Pattern p = Pattern.compile("^(\\d+)c(\\d+)$", 2);
            ArrayList<Image> imgs = new ArrayList<Image>(o.length - 1);
            for (int i = 1; i < o.length; ++i) {
                Image img;
                Matcher m = p.matcher(o[i]);
                if (m.matches()) {
                    String width = m.group(1);
                    String height = m.group(2);
                    img = new Image();
                    if (!"0".equals(width)) {
                        img.setWidth(Integer.parseInt(width));
                    }
                    if (!"0".equals(height)) {
                        img.setHeight(Integer.parseInt(height));
                    }
                } else {
                    throw new IllegalArgumentException("url param is illegal.");
                }
                img.setPath(back[0] + "/" + o[i]);
                imgs.add(img);
            }
            back[1] = imgs;
        }
        return back;
    }

    public static String tmp2Official(String fileName, String baseRealPath, String filePath, boolean createSmallImg) throws IOException {
        fileName = FilenameUtils.getName((String)fileName);
        if (createSmallImg) {
            Object[] urlAndImgs = FileUtils.analyzeUploadImgUrl(filePath, false, true);
            List smallImgs = urlAndImgs[1] == null ? null : (List)urlAndImgs[1];
            int size = (smallImgs == null ? 0 : smallImgs.size()) + 1;
            String returnPath = null;
            for (int i = 0; i < size; ++i) {
                String tmpPath = i == 0 ? baseRealPath + "/" + (String)urlAndImgs[0] : baseRealPath + "/" + ((Image)smallImgs.get(i - 1)).getPath();
                String path = tmpPath.replaceFirst("tmp/", "");
                if (size > 1 && i == 1 || size == 1) {
                    returnPath = path.replace(baseRealPath + "/", "");
                }
                File rawImg = new File(tmpPath, fileName);
                File newImg = new File(path, fileName);
                if (!newImg.getParentFile().exists()) {
                    newImg.getParentFile().mkdirs();
                }
                rawImg.renameTo(newImg);
            }
            return returnPath + "/" + fileName;
        }
        Object[] urlAndImgs = FileUtils.analyzeUploadImgUrl(filePath, true, true);
        String tmpPath = baseRealPath + "/" + urlAndImgs[0];
        String path = tmpPath.replaceFirst("tmp/", "");
        File rawImg = new File(tmpPath, fileName);
        File newImg = new File(path, fileName);
        if (!newImg.getParentFile().exists()) {
            newImg.getParentFile().mkdirs();
        }
        rawImg.renameTo(newImg);
        return path.replace(baseRealPath + "/", "") + "/" + fileName;
    }

    static <T extends Comparable<T>> T processRule(String rules, String ruleType, boolean obtainMaxVal, Class<T> target) {
        Pattern p = Pattern.compile(ruleType + "\\(([^\\)]*)\\)");
        Matcher m = p.matcher(rules);
        String result = null;
        while (m.find()) {
            Object tmp = null;
            if (Number.class.isAssignableFrom(target)) {
                try {
                    Constructor<T> c = target.getConstructor(String.class);
                    tmp = (Comparable)c.newInstance(m.group(1));
                }
                catch (Exception exception) {}
            } else if (String.class.isAssignableFrom(target)) {
                tmp = m.group(1);
            } else {
                throw new IllegalArgumentException(target + " can not be supported.");
            }
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            if (obtainMaxVal && tmp.compareTo(result) > 0) {
                result = tmp;
                continue;
            }
            if (obtainMaxVal || tmp.compareTo(result) >= 0) continue;
            result = tmp;
        }
        return (T)result;
    }

    public static CodeMsg validate(String rules, InputStream[] iss, String[] filenames, long[] fileSizes, Integer maxSize, boolean transaction) {
        Assert.notEmpty(iss);
        if (StringUtils.isBlank((String)rules)) {
            return CodeMsg.FAIL.msg("\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        rules = RegularUtils.getQueryString(rules);
        Double sl = null;
        Double sg = null;
        String type = null;
        String error = null;
        if (StringUtils.isNotBlank((String)rules)) {
            sl = FileUtils.processRule(rules, "sl", false, Double.class);
            if (maxSize != null && maxSize > 0 && (sl == null || (double)maxSize.intValue() < sl)) {
                sl = maxSize.doubleValue();
            }
            sg = FileUtils.processRule(rules, "sg", true, Double.class);
            type = FileUtils.processRule(rules, "type", true, String.class);
        }
        FileInfo[] files = new FileInfo[iss.length];
        for (int i = 0; i < iss.length; ++i) {
            FileInfo file = new FileInfo();
            file.setSize(FileUtils.byte2m(fileSizes[i], 2));
            files[i] = file;
            try {
                String mimeType;
                Object fileType = null;
                Object[] realFileExts = null;
                if (filenames != null && i < filenames.length && StringUtils.isNotBlank((String)filenames[i])) {
                    fileType = FilenameUtils.getExtension((String)filenames[i]).toLowerCase();
                }
                if ((mimeType = MimeTypes.getMimeTypeByTika(iss[i])) != null) {
                    realFileExts = MimeTypes.getExtensions(mimeType);
                    if (realFileExts == null) {
                        LOG.warn((Object)"File 'mime.types' not contain mime type pair '{0}'-'{1}'. Please ADD this pair.", mimeType, fileType);
                    } else if (realFileExts.length > 0) {
                        boolean exist = true;
                        if (fileType != null && !ArrayUtils.contains((Object[])realFileExts, (Object)fileType)) {
                            LOG.warn((Object)"File 'mime.types' not contain mime type pair '{0}'-'{1}'. Please VERIFY this pair.", mimeType, fileType);
                            exist = false;
                        }
                        fileType = fileType == null || !exist ? realFileExts[0] : fileType;
                    }
                } else {
                    LOG.warn((Object)"Filename '{0}' can't analyse mime type by Tika.", filenames[i]);
                }
                file.setType((String)fileType);
                if (sl != null && FileUtils.byte2m(fileSizes[i], 6) > sl) {
                    error = "\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + DecimalUtils.fmt(sl, 2, true) + "M";
                    if (transaction) {
                        return CodeMsg.FAIL.msg(error, new Object[0]);
                    }
                    file.setError(error);
                    continue;
                }
                if (sg != null && FileUtils.byte2m(fileSizes[i], 6) < sg) {
                    error = "\u6587\u4ef6\u4e0d\u80fd\u5c0f\u4e8e" + DecimalUtils.fmt(sg, 2, true) + "M";
                    if (transaction) {
                        return CodeMsg.FAIL.msg(error, new Object[0]);
                    }
                    file.setError(error);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)type)) continue;
                boolean auth = false;
                if (realFileExts != null) {
                    String[] allowTypes;
                    for (String t : allowTypes = type.split(",")) {
                        if (!ArrayUtils.contains((Object[])realFileExts, (Object)t)) continue;
                        auth = true;
                        break;
                    }
                }
                if (auth) continue;
                error = "\u6587\u4ef6\u683c\u5f0f\u53ea\u80fd\u4e3a" + type;
                if (transaction) {
                    return CodeMsg.FAIL.msg(error, new Object[0]);
                }
                file.setError(error);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"\u89e3\u6790\u6587\u4ef6\u9519\u8bef", e);
                error = "\u4e0a\u4f20\u5931\u8d25";
                if (transaction) {
                    return CodeMsg.FAIL.msg(error, new Object[0]);
                }
                file.setError(error);
            }
        }
        return CodeMsg.SUC.data(files);
    }

    public static void main(String[] args) {
    }
}

