/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.file.FileUtils;
import com.easycodebox.common.file.Image;
import com.easycodebox.common.file.MimeTypes;
import com.easycodebox.common.file.exception.NonEnlargedException;
import com.easycodebox.common.lang.DecimalUtils;
import com.easycodebox.common.lang.RegularUtils;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ImageTools {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTools.class);
    public static final String BIG_IMG = "960c760";
    public static final Integer BIG_IMG_WIDTH = 960;
    public static final Integer BIG_IMG_HEIGHT = 760;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeMsg validateImgs(String rules, File ... imgs) {
        ImageInputStream[] stream = new ImageInputStream[imgs.length];
        long[] lengths = new long[imgs.length];
        try {
            for (int i = 0; i < imgs.length; ++i) {
                stream[i] = ImageIO.createImageInputStream(imgs[i]);
                lengths[i] = imgs[i].length();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"\u89e3\u6790\u56fe\u7247\u9519\u8bef", e);
            CodeMsg codeMsg = CodeMsg.FAIL.msg("\u89e3\u6790\u56fe\u7247\u9519\u8bef", new Object[0]);
            return codeMsg;
        }
        finally {
            for (ImageInputStream is : stream) {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
        return ImageTools.validateImgs(rules, stream, lengths, null, false);
    }

    public static CodeMsg validateImgs(String rules, InputStream[] imgs, long[] fileSizes, Integer maxSize, boolean transaction) {
        ImageInputStream[] stream = new ImageInputStream[imgs.length];
        try {
            for (int i = 0; i < imgs.length; ++i) {
                stream[i] = ImageIO.createImageInputStream(imgs[i]);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"\u89e3\u6790\u56fe\u7247\u9519\u8bef", e);
            return CodeMsg.FAIL.msg("\u89e3\u6790\u56fe\u7247\u9519\u8bef", new Object[0]);
        }
        return ImageTools.validateImgs(rules, stream, fileSizes, maxSize, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeMsg validateImgs(String rules, ImageInputStream[] imgs, long[] fileSizes, Integer maxSize, boolean transaction) {
        Assert.notEmpty(imgs);
        if (StringUtils.isBlank((String)rules)) {
            return CodeMsg.FAIL.msg("\u56fe\u7247\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        rules = RegularUtils.getQueryString(rules);
        Double wl = null;
        Double wg = null;
        Double hl = null;
        Double hg = null;
        Double re = null;
        Double rl = null;
        Double rg = null;
        Double sl = null;
        Double sg = null;
        String type = null;
        String error = null;
        if (StringUtils.isNotBlank((String)rules)) {
            wl = FileUtils.processRule(rules, "wl", false, Double.class);
            wg = FileUtils.processRule(rules, "wg", true, Double.class);
            hl = FileUtils.processRule(rules, "hl", false, Double.class);
            hg = FileUtils.processRule(rules, "hg", true, Double.class);
            re = FileUtils.processRule(rules, "re", false, Double.class);
            rl = FileUtils.processRule(rules, "rl", false, Double.class);
            rg = FileUtils.processRule(rules, "rg", true, Double.class);
            sl = FileUtils.processRule(rules, "sl", false, Double.class);
            if (maxSize != null && maxSize > 0 && (sl == null || (double)maxSize.intValue() < sl)) {
                sl = maxSize.doubleValue();
            }
            sg = FileUtils.processRule(rules, "sg", true, Double.class);
            type = FileUtils.processRule(rules, "type", true, String.class);
        }
        Image[] newImgs = new Image[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            CodeMsg codeMsg;
            ImageReader reader = null;
            Image im = new Image();
            im.setSize(FileUtils.byte2m(fileSizes[i], 2));
            newImgs[i] = im;
            try {
                BigDecimal reDec22;
                Iterator<ImageReader> iter = ImageIO.getImageReaders(imgs[i]);
                if (!iter.hasNext()) {
                    error = "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef";
                    if (transaction) {
                        codeMsg = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg;
                    }
                    im.setError(error);
                    continue;
                }
                reader = iter.next();
                String imgType = reader.getFormatName().toLowerCase();
                String mimeType = MimeTypes.getMimeTypeByExt(imgType);
                if (mimeType != null) {
                    String[] exts = MimeTypes.getExtensions(mimeType);
                    imgType = exts[0];
                } else {
                    LOG.error("\u672a\u77e5\u7684\u56fe\u7247\u7c7b\u578b\uff1a" + imgType);
                }
                im.setType(imgType);
                ImageReadParam param = reader.getDefaultReadParam();
                reader.setInput(imgs[i], true, true);
                BufferedImage img = reader.read(0, param);
                int w = img.getWidth();
                int h = img.getHeight();
                BigDecimal ratio = new BigDecimal(1.0 * (double)w / (double)h).setScale(2, 4);
                if (wl != null && (double)w > wl) {
                    error = "\u56fe\u7247\u5bbd\u5ea6\u4e0d\u80fd\u5927\u4e8e" + DecimalUtils.fmt(wl, 2, true) + "\u50cf\u7d20";
                    if (transaction) {
                        CodeMsg codeMsg2 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg2;
                    }
                    im.setError(error);
                    continue;
                }
                if (wg != null && (double)w < wg) {
                    error = "\u56fe\u7247\u5bbd\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + DecimalUtils.fmt(wg, 2, true) + "\u50cf\u7d20";
                    if (transaction) {
                        CodeMsg codeMsg3 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg3;
                    }
                    im.setError(error);
                    continue;
                }
                if (hl != null && (double)h > hl) {
                    error = "\u56fe\u7247\u9ad8\u5ea6\u4e0d\u80fd\u5927\u4e8e" + DecimalUtils.fmt(hl, 2, true) + "\u50cf\u7d20";
                    if (transaction) {
                        CodeMsg codeMsg4 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg4;
                    }
                    im.setError(error);
                    continue;
                }
                if (hg != null && (double)h < hg) {
                    error = "\u56fe\u7247\u9ad8\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + DecimalUtils.fmt(hg, 2, true) + "\u50cf\u7d20";
                    if (transaction) {
                        CodeMsg codeMsg5 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg5;
                    }
                    im.setError(error);
                    continue;
                }
                if (re != null && (ratio.compareTo((reDec22 = new BigDecimal(re.toString()).setScale(2, 4)).subtract(new BigDecimal("0.1"))) < 0 || ratio.compareTo(reDec22.add(new BigDecimal("0.1"))) > 0)) {
                    error = "\u8bf7\u786e\u5b9a\u56fe\u7247\u7684\u5bbd\u9ad8\u6bd4\u4f8b\u662f" + DecimalUtils.fmt(reDec22, 2, true);
                    if (transaction) {
                        CodeMsg codeMsg6 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return codeMsg6;
                    }
                    im.setError(error);
                    continue;
                }
                if (rl != null && ratio.doubleValue() > rl) {
                    error = "\u56fe\u7247\u7684\u5bbd\u9ad8\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e" + DecimalUtils.fmt(rl, 2, true);
                    if (transaction) {
                        CodeMsg reDec22 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return reDec22;
                    }
                    im.setError(error);
                    continue;
                }
                if (rg != null && ratio.doubleValue() < rg) {
                    error = "\u56fe\u7247\u7684\u5bbd\u9ad8\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e" + DecimalUtils.fmt(rg, 2, true);
                    if (transaction) {
                        CodeMsg reDec22 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return reDec22;
                    }
                    im.setError(error);
                    continue;
                }
                if (sl != null && FileUtils.byte2m(fileSizes[i], 6) > sl) {
                    error = "\u56fe\u7247\u4e0d\u80fd\u5927\u4e8e" + DecimalUtils.fmt(sl, 2, true) + "M";
                    if (transaction) {
                        CodeMsg reDec22 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return reDec22;
                    }
                    im.setError(error);
                    continue;
                }
                if (sg != null && FileUtils.byte2m(fileSizes[i], 6) < sg) {
                    error = "\u56fe\u7247\u4e0d\u80fd\u5c0f\u4e8e" + DecimalUtils.fmt(sg, 2, true) + "M";
                    if (transaction) {
                        CodeMsg reDec22 = CodeMsg.FAIL.msg(error, new Object[0]);
                        return reDec22;
                    }
                    im.setError(error);
                    continue;
                }
                if (StringUtils.isNotBlank((String)type)) {
                    String[] allowTypes;
                    boolean auth = false;
                    for (String t : allowTypes = type.split(",")) {
                        if (!t.equalsIgnoreCase(imgType)) continue;
                        auth = true;
                    }
                    if (!auth) {
                        error = "\u56fe\u7247\u683c\u5f0f\u53ea\u80fd\u4e3a" + type;
                        if (transaction) {
                            CodeMsg codeMsg2 = CodeMsg.FAIL.msg(error, new Object[0]);
                            return codeMsg2;
                        }
                        im.setError(error);
                        continue;
                    }
                }
                im.setWidth(w);
                im.setHeight(h);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"\u89e3\u6790\u56fe\u7247\u9519\u8bef", e);
                error = "\u89e3\u6790\u56fe\u7247\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6709\u6548\u56fe\u7247\u3002";
                if (transaction) {
                    codeMsg = CodeMsg.FAIL.msg(error, new Object[0]);
                    return codeMsg;
                }
                im.setError(error);
                continue;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
        return CodeMsg.SUC.data(newImgs);
    }

    public static boolean fillScaleImg(String srcImg, String descImg, int width, int height, boolean enlarge) {
        if (StringUtils.isBlank((String)srcImg) || StringUtils.isBlank((String)descImg)) {
            LOG.warn("img is balnk in the method resizeImage of ImageTools.Class .");
            return false;
        }
        try {
            BufferedImage img = ImageIO.read(new FileInputStream(srcImg));
            int w = img.getWidth();
            int h = img.getHeight();
            int[] tmp = ImageTools.scaleSize(w, h, width, height, true, enlarge);
            BufferedImage newImg = new BufferedImage(width, height, 5);
            java.awt.Image imgObj = img.getScaledInstance(tmp[0], tmp[1], 1);
            Graphics2D g = newImg.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            int wv = (width - tmp[0]) / 2;
            int hv = (height - tmp[1]) / 2;
            g.drawImage(imgObj, wv, hv, Color.WHITE, null);
            g.dispose();
            File newFile = new File(descImg);
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)newImg, FilenameUtils.getExtension((String)descImg).toLowerCase(), newFile);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"read img error.", e);
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)"read img error.", e);
            return false;
        }
        return true;
    }

    public static int[] scaleSize(int originWidth, int originHeight, Integer width, Integer height, boolean scale, boolean enlarge) {
        int[] wh = new int[2];
        if (width == null && height == null) {
            wh[0] = originWidth;
            wh[1] = originHeight;
        } else if (width == null) {
            double scaleH = 1.0 * (double)originHeight / (double)height.intValue();
            if (!enlarge && scaleH < 1.0) {
                wh[0] = originWidth;
                wh[1] = originHeight;
            } else {
                wh[0] = (int)((double)originWidth / scaleH);
                wh[1] = height;
            }
        } else if (height == null) {
            double scaleW = 1.0 * (double)originWidth / (double)width.intValue();
            if (!enlarge && scaleW < 1.0) {
                wh[0] = originWidth;
                wh[1] = originHeight;
            } else {
                wh[0] = width;
                wh[1] = (int)((double)originHeight / scaleW);
            }
        } else if (!scale) {
            if (!(enlarge || originWidth >= width && originHeight >= height)) {
                wh[0] = originWidth;
                wh[1] = originHeight;
            } else {
                wh[0] = width;
                wh[1] = height;
            }
        } else {
            double scaleH;
            double scaleW = 1.0 * (double)originWidth / (double)width.intValue();
            double newScale = scaleW > (scaleH = 1.0 * (double)originHeight / (double)height.intValue()) ? scaleW : scaleH;
            if (!enlarge && newScale < 1.0) {
                wh[0] = originWidth;
                wh[1] = originHeight;
            } else {
                wh[0] = (int)((double)originWidth / newScale);
                wh[1] = (int)((double)originHeight / newScale);
            }
        }
        return wh;
    }

    public static Image getImageInfo(File fileImage) throws Exception {
        Image image = new Image();
        BufferedImage bufferImage = ImageIO.read(fileImage);
        image.setHeight(bufferImage.getHeight());
        image.setWidth(bufferImage.getWidth());
        image.setSize(FileUtils.byte2m(fileImage.length(), 2));
        return image;
    }

    public static void cutImage(File image, String outputFile, Rectangle rect) throws IOException {
        ImageTools.cutImage(image, outputFile, rect.x, rect.y, rect.width, rect.height);
    }

    public static void cutImage(File image, String outputFile, int x, int y, int width, int height) throws IOException {
        BufferedImage scrBuffer = ImageIO.read(image);
        BufferedImage desBuffer = scrBuffer.getSubimage(x, y, width, height);
        ImageIO.write((RenderedImage)desBuffer, FilenameUtils.getExtension((String)outputFile).toLowerCase(), new File(outputFile));
    }

    public static void mergeImages(String source1, String source2, String des, String type, int x, int y, int width, int height) throws Exception {
        BufferedImage img1 = ImageIO.read(new File(source1));
        BufferedImage img2 = ImageIO.read(new File(source2));
        Graphics g = img1.getGraphics();
        g.drawImage(img2, x, y, width, height, null);
        g.dispose();
        ImageIO.write((RenderedImage)img1, type, new File(des));
    }

    @Deprecated
    public static Image[] resizeImage(BufferedImage img, String imgName, String baseRealPath, boolean scale, boolean enlarge, List<Image> resizeImg) throws Exception {
        if (img == null || resizeImg.size() == 0) {
            throw new IllegalArgumentException("img or resizeImg is balnk in the method resizeImage of ImageTools.Class .");
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Image[] returnImgs = new Image[resizeImg.size()];
        for (int i = 0; i < resizeImg.size(); ++i) {
            Image t = resizeImg.get(i);
            if (StringUtils.isBlank((String)t.getName())) {
                t.setName(imgName);
            }
            Integer width = t.getWidth();
            Integer height = t.getHeight();
            if (!(enlarge || BIG_IMG_WIDTH.equals(width) && BIG_IMG_HEIGHT.equals(height))) {
                if (width != null && width > w) {
                    throw new NonEnlargedException("\u539f\u56fe\u7247\u5bbd\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + width);
                }
                if (height != null && height > h) {
                    throw new NonEnlargedException("\u539f\u56fe\u7247\u9ad8\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + height);
                }
            }
            int[] tmp = ImageTools.scaleSize(w, h, width, height, scale, enlarge);
            width = tmp[0];
            height = tmp[1];
            BufferedImage newBufferedImg = new BufferedImage(width, height, 5);
            java.awt.Image imgObj = img.getScaledInstance(width, height, 1);
            Graphics2D g = newBufferedImg.createGraphics();
            g.drawImage(imgObj, 0, 0, Color.WHITE, null);
            g.dispose();
            File newFile = new File(baseRealPath + "/" + t.getPath() + "/" + t.getName());
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)newBufferedImg, FilenameUtils.getExtension((String)t.getName()).toLowerCase(), newFile);
            Image sImg = new Image();
            PropertyUtils.copyProperties((Object)sImg, (Object)t);
            sImg.setWidth(width);
            sImg.setHeight(height);
            returnImgs[i] = sImg;
        }
        return returnImgs;
    }

    @Deprecated
    public static String cutImageComplex(String imgPath, String baseRealPath, String filePath, int x, int y, int width, int height) throws Exception {
        Object[] urlAndImgs = FileUtils.analyzeUploadImgUrl(filePath, false, false);
        List smallImgs = urlAndImgs[1] == null ? null : (List)urlAndImgs[1];
        File tmp = new File(baseRealPath + "/" + imgPath);
        String imgName = FilenameUtils.getName((String)imgPath);
        File bigImg = new File(baseRealPath + "/" + urlAndImgs[0] + "/" + imgName);
        if (!bigImg.getParentFile().exists()) {
            bigImg.getParentFile().mkdirs();
        }
        tmp.renameTo(bigImg);
        if (smallImgs == null || smallImgs.size() == 0) {
            return urlAndImgs[0] + "/" + imgName;
        }
        BufferedImage scrBuffer = ImageIO.read(bigImg);
        scrBuffer = scrBuffer.getSubimage(x, y, width, height);
        Image[] imgs = ImageTools.resizeImage(scrBuffer, imgName, baseRealPath, false, true, smallImgs);
        return imgs[0].getPath() + "/" + imgs[0].getName();
    }

    private static void testGenerateSmallImg(File path) {
        File[] files = path.listFiles();
        String absolutePath = path.getAbsolutePath().replace("D:\\back\\imgs", "D:\\back\\imgs\\g");
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isFile()) {
                try {
                    ArrayList<Image> resizeImg = new ArrayList<Image>(1);
                    Image img = new Image();
                    img.setPath("");
                    img.setWidth(960);
                    img.setHeight(760);
                    resizeImg.add(img);
                    BufferedImage tmpImg = ImageIO.read(files[i]);
                    ImageTools.resizeImage(tmpImg, f.getName(), absolutePath, true, false, resizeImg);
                    tmpImg.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (f.getName().equals("mobilePath")) continue;
            ImageTools.testGenerateSmallImg(f);
        }
    }

    public static void main(String[] args) {
        try {
            long cur = System.currentTimeMillis();
            for (int i = 0; i < 10000; ++i) {
                ImageTools.validateImgs("wg(420)hg(420)", new File("e:/a.jpg"));
            }
            System.out.println(System.currentTimeMillis() - cur);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

