/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.file.MimetypesFileTypeMap;
import com.easycodebox.common.file.TikaFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public class MimeTypes {
    private MimeTypes() {
    }

    public static String getMimeType(String path) {
        return MimetypesFileTypeMap.getInstance().getContentType(path);
    }

    public static String getMimeTypeByExt(String extension) {
        return MimetypesFileTypeMap.getInstance().getContentTypeByExt(extension);
    }

    public static String[] getExtensions(String mimeType) {
        return MimetypesFileTypeMap.getInstance().getExtensions(mimeType);
    }

    public static String getMimeTypeByTika(String path) throws IOException {
        return TikaFactory.getInstance().detect(path);
    }

    public static String getMimeTypeByTika(File file) throws IOException {
        return TikaFactory.getInstance().detect(file);
    }

    public static String getMimeTypeByTika(InputStream stream) throws IOException {
        return TikaFactory.getInstance().detect(stream);
    }

    public static String getMimeTypeByJavaNet(String path) {
        return URLConnection.guessContentTypeFromName(path);
    }

    public static String getMimeTypeMagicByJavaNet(String path) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(path)));
        return URLConnection.guessContentTypeFromStream(is);
    }
}

