/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final Logger LOG = LoggerFactory.getLogger(MimetypesFileTypeMap.class);
    private static MimeTypeFile defDB = null;
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static String DEFAUL_TTYPE = "application/octet-stream";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimetypesFileTypeMap() {
        ArrayList<MimeTypeFile> dbv = new ArrayList<MimeTypeFile>(5);
        MimeTypeFile mf = null;
        dbv.add(null);
        LOG.info("MimetypesFileTypeMap: load HOME");
        try {
            String path;
            String user_home = System.getProperty("user.home");
            if (user_home != null && (mf = this.loadFile(path = user_home + File.separator + ".mime.types")) != null) {
                dbv.add(mf);
            }
        }
        catch (SecurityException user_home) {
            // empty catch block
        }
        LOG.info("MimetypesFileTypeMap: load SYS");
        try {
            String system_mimetypes = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mime.types";
            mf = this.loadFile(system_mimetypes);
            if (mf != null) {
                dbv.add(mf);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LOG.info("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mime.types");
        LOG.info("MimetypesFileTypeMap: load DEF");
        Class<MimetypesFileTypeMap> clazz = MimetypesFileTypeMap.class;
        synchronized (MimetypesFileTypeMap.class) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mimetypes.default");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (defDB != null) {
                dbv.add(defDB);
            }
            this.DB = dbv.toArray(new MimeTypeFile[0]);
            return;
        }
    }

    public static MimetypesFileTypeMap getInstance() {
        return MimetypesFileTypeMapSingleton.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MimeTypeFile loadResource(String name) {
        try (InputStream clis = ((Object)((Object)this)).getClass().getResourceAsStream(name);){
            if (clis != null) {
                MimeTypeFile mf = new MimeTypeFile(clis);
                LOG.info("MimetypesFileTypeMap: successfully loaded mime types file: " + name);
                MimeTypeFile mimeTypeFile = mf;
                return mimeTypeFile;
            }
            LOG.warn("MimetypesFileTypeMap: not loading mime types file: " + name);
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)"MimetypesFileTypeMap: load file ({0}) failed.", e, name);
        }
        return null;
    }

    private URL[] getResources(final ClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

            @Override
            public URL[] run() {
                URL[] ret = null;
                try {
                    Enumeration<URL> e;
                    ArrayList<URL> v = new ArrayList<URL>();
                    Enumeration<URL> enumeration = e = cl == null ? ClassLoader.getSystemResources(name) : cl.getResources(name);
                    while (e != null && e.hasMoreElements()) {
                        URL url = e.nextElement();
                        if (url == null) continue;
                        v.add(url);
                    }
                    if (v.size() > 0) {
                        ret = new URL[v.size()];
                        ret = v.toArray(ret);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    private void loadAllResources(List<MimeTypeFile> v, String name) {
        boolean anyLoaded = false;
        URL[] urls = this.getResources(ClassUtils.getClassLoader(), name);
        if (urls != null) {
            LOG.info("MimetypesFileTypeMap: getResources");
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                LOG.info("MimetypesFileTypeMap: URL " + url);
                try (InputStream clis = url.openStream();){
                    if (clis != null) {
                        v.add(new MimeTypeFile(clis));
                        anyLoaded = true;
                        LOG.info("MimetypesFileTypeMap: successfully loaded mime types from URL: " + url);
                        continue;
                    }
                    LOG.warn("MimetypesFileTypeMap: not loading mime types from URL: " + url);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("MimetypesFileTypeMap: can't load " + name), e);
                }
            }
        }
        if (!anyLoaded) {
            LOG.info("MimetypesFileTypeMap: !anyLoaded");
            MimeTypeFile mf = this.loadResource("/" + name);
            if (mf != null) {
                v.add(mf);
            }
        }
    }

    private MimeTypeFile loadFile(String name) {
        MimeTypeFile mtf = null;
        try {
            mtf = new MimeTypeFile(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mtf;
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(mimeTypeFileName);
    }

    public MimetypesFileTypeMap(InputStream is) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(mime_types);
    }

    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    public String getContentType(String filename) {
        int dot_pos = filename.lastIndexOf(".");
        if (dot_pos < 0) {
            return DEFAUL_TTYPE;
        }
        return this.getContentTypeByExt(filename.substring(dot_pos + 1));
    }

    public synchronized String getContentTypeByExt(String extension) {
        if (StringUtils.isBlank((String)extension)) {
            return DEFAUL_TTYPE;
        }
        for (MimeTypeFile mt : this.DB) {
            String result;
            if (mt == null || (result = mt.getMimeType(extension)) == null) continue;
            return result;
        }
        return DEFAUL_TTYPE;
    }

    public synchronized String[] getExtensions(String mimeType) {
        for (MimeTypeFile mt : this.DB) {
            String[] result;
            if (mt == null || (result = mt.getExts(mimeType)) == null) continue;
            return result;
        }
        return null;
    }

    class LineTokenizer {
        private int currentPosition = 0;
        private int maxPosition;
        private String str;
        private Vector<String> stack = new Vector();
        private static final String singles = "=";

        public LineTokenizer(String str) {
            this.str = str;
            this.maxPosition = str.length();
        }

        private void skipWhiteSpace() {
            while (this.currentPosition < this.maxPosition && Character.isWhitespace(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
        }

        public boolean hasMoreTokens() {
            if (this.stack.size() > 0) {
                return true;
            }
            this.skipWhiteSpace();
            return this.currentPosition < this.maxPosition;
        }

        public String nextToken() {
            int start;
            char c;
            int size = this.stack.size();
            if (size > 0) {
                String t = this.stack.elementAt(size - 1);
                this.stack.removeElementAt(size - 1);
                return t;
            }
            this.skipWhiteSpace();
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            if ((c = this.str.charAt(start = this.currentPosition++)) == '\"') {
                boolean filter = false;
                while (this.currentPosition < this.maxPosition) {
                    String s;
                    if ((c = this.str.charAt(this.currentPosition++)) == '\\') {
                        ++this.currentPosition;
                        filter = true;
                        continue;
                    }
                    if (c != '\"') continue;
                    if (filter) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = start + 1; i < this.currentPosition - 1; ++i) {
                            c = this.str.charAt(i);
                            if (c == '\\') continue;
                            sb.append(c);
                        }
                        s = sb.toString();
                    } else {
                        s = this.str.substring(start + 1, this.currentPosition - 1);
                    }
                    return s;
                }
            } else if (singles.indexOf(c) >= 0) {
                ++this.currentPosition;
            } else {
                while (this.currentPosition < this.maxPosition && singles.indexOf(this.str.charAt(this.currentPosition)) < 0 && !Character.isWhitespace(this.str.charAt(this.currentPosition))) {
                    ++this.currentPosition;
                }
            }
            return this.str.substring(start, this.currentPosition);
        }

        public void pushToken(String token) {
            this.stack.addElement(token);
        }
    }

    public class MimeTypeFile {
        private ConcurrentMap<String, String> extToType = new ConcurrentHashMap<String, String>();
        private ConcurrentMap<String, String[]> typeToExts = new ConcurrentHashMap<String, String[]>();

        public MimeTypeFile(String filename) throws IOException {
            try (FileReader fr = new FileReader(new File(filename));){
                this.parse(new BufferedReader(fr));
            }
        }

        public MimeTypeFile(InputStream is) throws IOException {
            this.parse(new BufferedReader(new InputStreamReader(is, "iso-8859-1")));
        }

        public MimeTypeFile() {
        }

        public String getMimeType(String file_ext) {
            return (String)this.extToType.get(file_ext.toLowerCase());
        }

        public String[] getExts(String mimeType) {
            return (String[])this.typeToExts.get(mimeType.toLowerCase());
        }

        public void appendToRegistry(String mime_types) {
            try {
                this.parse(new BufferedReader(new StringReader(mime_types)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void parse(BufferedReader buf_reader) throws IOException {
            String line = null;
            String prev = null;
            while ((line = buf_reader.readLine()) != null) {
                prev = prev == null ? line : prev + line;
                int end = prev.length();
                if (prev.length() > 0 && prev.charAt(end - 1) == '\\') {
                    prev = prev.substring(0, end - 1);
                    continue;
                }
                this.parseEntry(prev);
                prev = null;
            }
            if (prev != null) {
                this.parseEntry(prev);
            }
        }

        private void parseEntry(String line) {
            String mime_type = null;
            String file_ext = null;
            ArrayList<String> exts = new ArrayList<String>(4);
            if ((line = line.trim()).length() == 0) {
                return;
            }
            if (line.charAt(0) == '#') {
                return;
            }
            if (line.indexOf(61) > 0) {
                LineTokenizer lt = new LineTokenizer(line);
                while (lt.hasMoreTokens()) {
                    String name = lt.nextToken();
                    String value = null;
                    if (lt.hasMoreTokens() && lt.nextToken().equals("=") && lt.hasMoreTokens()) {
                        value = lt.nextToken();
                    }
                    if (value == null) {
                        LOG.info("Bad .mime.types entry: " + line);
                        return;
                    }
                    if (name.equals("type")) {
                        mime_type = value;
                        exts.clear();
                        continue;
                    }
                    if (!name.equals("exts")) continue;
                    StringTokenizer st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        file_ext = st.nextToken();
                        this.extToType.put(file_ext, mime_type);
                        exts.add(file_ext);
                    }
                    this.typeToExts.put(mime_type, exts.toArray(new String[0]));
                }
            } else {
                StringTokenizer strtok = new StringTokenizer(line);
                int num_tok = strtok.countTokens();
                if (num_tok == 0) {
                    return;
                }
                mime_type = strtok.nextToken();
                exts.clear();
                while (strtok.hasMoreTokens()) {
                    file_ext = strtok.nextToken();
                    this.extToType.put(file_ext, mime_type);
                    exts.add(file_ext);
                }
                this.typeToExts.put(mime_type, exts.toArray(new String[0]));
            }
        }
    }

    private static final class MimetypesFileTypeMapSingleton {
        static final MimetypesFileTypeMap INSTANCE = new MimetypesFileTypeMap();

        private MimetypesFileTypeMapSingleton() {
        }
    }
}

