/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.file.PropertiesUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class PropertiesPool {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesPool.class);
    private static final String[] properties;
    private static final String[] xmls;
    private static Properties propertyFile;
    private static final ReentrantLock lock;
    private static Set<String> files;

    private PropertiesPool() {
    }

    private static void init() {
        for (String fileStr : properties) {
            PropertiesPool.loadPropertiesFile(fileStr);
        }
        for (String xmlStr : xmls) {
            PropertiesPool.loadXMLFile(xmlStr);
        }
    }

    public static void loadPropertiesFile(String resource) {
        PropertiesPool.loadPropertiesFile(resource, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPropertiesFile(String resource, boolean absolute, boolean force) {
        block8: {
            Assert.notBlank(resource, "fileName can't be blank", new Object[0]);
            lock.lock();
            try {
                boolean contains = files.contains(resource);
                if (!force && contains) break block8;
                try {
                    if (absolute) {
                        PropertiesUtils.loadAbsoluteFile(propertyFile, resource);
                    } else {
                        PropertiesUtils.loadFile(propertyFile, resource);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Load file ({0}) to Properties error!!", e, resource);
                }
                if (!contains) {
                    files.add(resource);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void loadXMLFile(String resource) {
        PropertiesPool.loadXMLFile(resource, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadXMLFile(String resource, boolean absolute, boolean force) {
        block8: {
            Assert.notBlank(resource, "fileName can't be blank", new Object[0]);
            lock.lock();
            try {
                boolean contains = files.contains(resource);
                if (!force && contains) break block8;
                try {
                    if (absolute) {
                        PropertiesUtils.loadAbsoluteXmlFile(propertyFile, resource);
                    } else {
                        PropertiesUtils.loadXmlFile(propertyFile, resource);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Load xml file ({0}) to Properties error!!", e, resource);
                }
                if (!contains) {
                    files.add(resource);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static Object get(Object key) {
        return propertyFile.get(key);
    }

    public static Object get(Object key, String defaultValue) {
        Object val = propertyFile.get(key);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public static String getProperty(String key) {
        return propertyFile.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return propertyFile.getProperty(key, defaultValue);
    }

    public static void addProperties(Properties properties) {
        if (properties != null) {
            propertyFile.putAll((Map<?, ?>)properties);
        }
    }

    public static Properties getProperties() {
        return propertyFile;
    }

    public static void main(String[] args) {
        Properties propertyFile = new Properties();
        propertyFile.put("name", "1");
        propertyFile.put("name", "3");
        System.out.println(propertyFile.get("name"));
    }

    static {
        propertyFile = new Properties();
        lock = new ReentrantLock();
        files = new HashSet<String>();
        properties = new String[0];
        xmls = new String[0];
        PropertiesPool.init();
    }
}

