/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.file.PropertiesPool;
import com.easycodebox.common.lang.StringToken;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.validate.Assert;
import com.easycodebox.common.xml.XmlDataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.modelmbean.XMLParseException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtils.class);
    public static final String PLACEHOLDER_OPEN = "${";
    public static final String PLACEHOLDER_CLOSE = "}";

    public static void load(Properties properties, String dataStr) throws IOException {
        Assert.notNull((Object)properties, "'properties' can't be null.", new Object[0]);
        LOG.debug((Object)"properties load data string {0}.", dataStr);
        if (StringUtils.isNotBlank((String)dataStr)) {
            try (StringReader reader = new StringReader(dataStr);){
                properties.load(reader);
            }
        }
    }

    public static void loadFile(Properties properties, String resource) throws IOException {
        Assert.notNull((Object)properties, "'properties' can't be null.", new Object[0]);
        LOG.info((Object)"properties load file {0}.", resource);
        try (InputStream i = PropertiesPool.class.getResourceAsStream(resource);){
            properties.load(i);
        }
    }

    public static void loadAbsoluteFile(Properties properties, String absoluteFile) throws FileNotFoundException, IOException {
        Assert.notNull((Object)properties, "'properties' can't be null.", new Object[0]);
        LOG.info((Object)"properties load file {0}.", absoluteFile);
        try (FileInputStream i = new FileInputStream(absoluteFile);){
            properties.load(i);
        }
    }

    public static void loadXmlFile(Properties properties, String resource) throws IOException, DocumentException, XMLParseException {
        Assert.notNull((Object)properties, "'properties' can't be null.", new Object[0]);
        LOG.info((Object)"properties load xml file {0}.", resource);
        try (InputStream is = PropertiesPool.class.getResourceAsStream(resource);){
            PropertiesUtils.loadXmlFile(properties, is);
        }
    }

    public static void loadAbsoluteXmlFile(Properties properties, String absoluteFile) throws FileNotFoundException, IOException, DocumentException, XMLParseException {
        Assert.notNull((Object)properties, "'properties' can't be null.", new Object[0]);
        LOG.info((Object)"properties load file {0}.", absoluteFile);
        try (FileInputStream i = new FileInputStream(absoluteFile);){
            PropertiesUtils.loadXmlFile(properties, i);
        }
    }

    public static void loadXmlFile(Properties properties, InputStream i) throws DocumentException, XMLParseException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(i);
        Element root = document.getRootElement();
        List subs = root.elements("data");
        for (int j = 0; j < subs.size(); ++j) {
            Element e = (Element)subs.get(j);
            String nameVal = e.attributeValue("name");
            if (!StringUtils.isNotBlank((String)nameVal)) continue;
            properties.put(nameVal, XmlDataParser.parseDataElement(e));
        }
    }

    public static void store(Properties properties, String filePath) throws FileNotFoundException, IOException {
        File parent;
        Assert.notNull((Object)properties, "properties can not be null.", new Object[0]);
        Assert.notBlank(filePath, "filePath can not be blank.", new Object[0]);
        File file = new File(filePath);
        if (!file.exists() && !(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            properties.store(fos, "filename rule cfg");
        }
    }

    public static Properties processPlaceholder(Properties properties, boolean updateRaw) {
        Properties props = updateRaw ? properties : (Properties)properties.clone();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            PropertiesUtils.loopPlaceholderVal(props, entry.getKey(), new LinkedList<Object>());
        }
        return props;
    }

    private static String loopPlaceholderVal(Properties props, Object key, LinkedList<Object> visits) {
        visits.push(key);
        Object val = props.get(key);
        if (val instanceof String) {
            String tmpVal;
            StringToken.StringFormatToken token = new StringToken.StringFormatToken(PLACEHOLDER_OPEN, PLACEHOLDER_CLOSE, (String)val, true);
            String phkey = null;
            while ((phkey = token.nextKey()) != null) {
                if (visits.contains(phkey)) {
                    throw new BaseException("Infinite loop exception.Cause by properties key '{0}'.", phkey);
                }
                tmpVal = PropertiesUtils.loopPlaceholderVal(props, phkey, visits);
                token.insertBack(tmpVal == null ? PLACEHOLDER_OPEN + phkey + PLACEHOLDER_CLOSE : tmpVal);
            }
            tmpVal = token.getAssemble();
            if (!val.equals(tmpVal)) {
                props.put(key, tmpVal);
                val = tmpVal;
            }
        }
        visits.pop();
        return val == null ? null : val.toString();
    }

    public static void main(String[] args) {
        String dataStr = "name=xxxx\nage=yyyy";
        Properties properties = new Properties();
        try {
            PropertiesUtils.load(properties, dataStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(properties.get("name"));
        System.out.println(properties.get("age"));
    }
}

