/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class Resources {
    private static ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public static List<Class<?>> scanClass(String ... packages) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (packages != null && packages.length > 0) {
            for (int i = 0; i < packages.length; ++i) {
                packages[i] = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packages[i]) + "/**/*.class";
            }
        }
        List<Resource> resources = Resources.scan(packages);
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        for (Resource resource : resources) {
            if (!resource.isReadable()) continue;
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            String className = reader.getClassMetadata().getClassName();
            Class<?> clazz = resourcePatternResolver.getClassLoader().loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public static List<Resource> scan(String ... locationPattern) throws IOException {
        ArrayList<Resource> list = new ArrayList<Resource>();
        if (locationPattern != null && locationPattern.length > 0) {
            for (String location : locationPattern) {
                Resource[] resources;
                for (Resource resource : resources = resourcePatternResolver.getResources(location)) {
                    if (!resource.isReadable()) continue;
                    list.add(resource);
                }
            }
        }
        return list;
    }

    public static List<File> scan2File(String ... locationPattern) throws IOException, ClassNotFoundException {
        ArrayList<File> rs = new ArrayList<File>();
        List<Resource> resources = Resources.scan(locationPattern);
        for (Resource r : resources) {
            rs.add(r.getFile());
        }
        return rs;
    }

    public static List<InputStream> scan2InputStream(String ... locationPattern) throws IOException, ClassNotFoundException {
        ArrayList<InputStream> rs = new ArrayList<InputStream>();
        List<Resource> resources = Resources.scan(locationPattern);
        for (Resource r : resources) {
            rs.add(r.getInputStream());
        }
        return rs;
    }

    public static List<URL> scan2URL(String ... locationPattern) throws IOException, ClassNotFoundException {
        ArrayList<URL> rs = new ArrayList<URL>();
        List<Resource> resources = Resources.scan(locationPattern);
        for (Resource r : resources) {
            rs.add(r.getURL());
        }
        return rs;
    }

    public static void main(String[] args) {
        try {
            System.out.println(Resources.scan("classpath*:com/easycodebox/common/*.class"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

