/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.filter;

import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.ParameterRequestWrapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class CharacterEncodingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CharacterEncodingFilter.class);
    private String encoding;
    private boolean forceEncoding = false;
    private String attributeKey;
    private boolean decodeGetParams = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.encoding = filterConfig.getInitParameter("encoding");
        String feStr = filterConfig.getInitParameter("forceEncoding");
        if (StringUtils.isNotBlank((String)feStr)) {
            this.forceEncoding = Boolean.parseBoolean(feStr);
        }
        this.attributeKey = StringUtils.isBlank((String)filterConfig.getFilterName()) ? CharacterEncodingFilter.class.getName() + ".filter" : filterConfig.getFilterName();
        String dgp = filterConfig.getInitParameter("decodeGetParams");
        if (StringUtils.isNotBlank((String)dgp)) {
            this.decodeGetParams = Boolean.parseBoolean(dgp);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean encoded;
        boolean bl = encoded = request.getAttribute(this.attributeKey) != null;
        if (encoded) {
            chain.doFilter(request, response);
        } else {
            request.setAttribute(this.attributeKey, (Object)Boolean.TRUE);
            HttpServletRequest req = (HttpServletRequest)request;
            try {
                if (this.encoding != null && (this.forceEncoding || request.getCharacterEncoding() == null)) {
                    request.setCharacterEncoding(this.encoding);
                    if (this.forceEncoding) {
                        response.setCharacterEncoding(this.encoding);
                    }
                    if (this.decodeGetParams && "GET".equals(req.getMethod()) && StringUtils.isNotBlank((String)req.getQueryString())) {
                        HashMap params = new HashMap(request.getParameterMap());
                        for (String key : params.keySet()) {
                            String[] values = (String[])params.get(key);
                            if (values == null) continue;
                            for (int i = 0; i < values.length; ++i) {
                                values[i] = URLDecoder.decode(values[i], this.encoding);
                            }
                        }
                        ParameterRequestWrapper wrapperRequest = new ParameterRequestWrapper(req, params);
                        request = wrapperRequest;
                    }
                }
                chain.doFilter(request, response);
            }
            catch (IOException e) {
                LOG.warn((Object)"Encoding URL error, {0}.", req.getRequestURL().append("?").append(req.getQueryString()));
                throw e;
            }
            finally {
                request.removeAttribute(this.attributeKey);
            }
        }
    }

    public void destroy() {
    }
}

