/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.filter;

import com.easycodebox.common.BaseConstants;
import com.easycodebox.common.enums.Enums;
import com.easycodebox.common.enums.entity.LogLevel;
import com.easycodebox.common.error.BaseException;
import com.easycodebox.common.error.CodeMsg;
import com.easycodebox.common.error.ErrorContext;
import com.easycodebox.common.error.ExceptionHandler;
import com.easycodebox.common.filter.LogLevelException;
import com.easycodebox.common.jackson.Jacksons;
import com.easycodebox.common.lang.StringUtils;
import com.easycodebox.common.lang.reflect.ClassUtils;
import com.easycodebox.common.log.slf4j.LogLevelConfig;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.net.HttpUtils;
import com.easycodebox.common.web.callback.Callbacks;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ErrorContextFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorContextFilter.class);
    private static final String REDIRECT_FLAG = "redirect:";
    private static final String SEPARATOR_PATTERN = "[,\n]";
    private final String errorKey = "CODE_MSG";
    private final String storeExceptionKey = "EXCEPTION_INFO";
    private WebApplicationContext context;
    private int depth = 2;
    private String defaultPage;
    private int defaultStatus = 500;
    private Map<Class<?>, String> exceptionMappings = Collections.emptyMap();
    private Map<String, Integer> statusMappings = Collections.emptyMap();
    private Map<Class<?>, Boolean> logMappings = Collections.emptyMap();
    private boolean isLog = true;
    private LogLevelConfig logLevelConfig = new LogLevelConfig();
    private boolean storeException = false;
    private ExceptionHandler exceptionHandler;

    public void init(FilterConfig filterConfig) throws ServletException {
        LogLevel logLevelEnum;
        String[] vals;
        String[] frags;
        String defaultPage = filterConfig.getInitParameter("defaultPage");
        String defaultStatus = filterConfig.getInitParameter("defaultStatus");
        String exceptionMappings = filterConfig.getInitParameter("exceptionMappings");
        String statusMappings = filterConfig.getInitParameter("statusMappings");
        String logMappings = filterConfig.getInitParameter("logMappings");
        String isLog = filterConfig.getInitParameter("isLog");
        String logLevel = filterConfig.getInitParameter("logLevel");
        String store = filterConfig.getInitParameter("storeException");
        String exceptionHandlerBeanName = filterConfig.getInitParameter("exceptionHandlerBeanName");
        if (StringUtils.isNotBlank((String)defaultPage)) {
            this.defaultPage = defaultPage.trim();
        }
        if (StringUtils.isNotBlank((String)defaultStatus)) {
            this.defaultStatus = Integer.parseInt(defaultStatus.trim());
        }
        if (StringUtils.isNotBlank((String)exceptionMappings)) {
            this.exceptionMappings = new HashMap(4);
            for (String frag : frags = exceptionMappings.split(SEPARATOR_PATTERN)) {
                if (!StringUtils.isNotBlank((String)frag) || (vals = frag.trim().split("=")).length != 2) continue;
                try {
                    this.exceptionMappings.put(ClassUtils.getClass((String)vals[0].trim()), vals[1].trim());
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Class not find.", e);
                }
            }
        }
        if (StringUtils.isNotBlank((String)statusMappings)) {
            this.statusMappings = new HashMap<String, Integer>(4);
            for (String frag : frags = statusMappings.split(SEPARATOR_PATTERN)) {
                if (!StringUtils.isNotBlank((String)frag) || (vals = frag.trim().split("=")).length != 2) continue;
                this.statusMappings.put(vals[0].trim(), Integer.parseInt(vals[1].trim()));
            }
        }
        if (StringUtils.isNotBlank((String)logMappings)) {
            this.logMappings = new HashMap(4);
            for (String frag : frags = logMappings.split(SEPARATOR_PATTERN)) {
                if (!StringUtils.isNotBlank((String)frag) || (vals = frag.trim().split("=")).length != 2) continue;
                try {
                    this.logMappings.put(ClassUtils.getClass((String)vals[0].trim()), Boolean.parseBoolean(vals[1].trim()));
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)"Class not find.", e);
                }
            }
        }
        if (StringUtils.isNotBlank((String)isLog)) {
            this.isLog = Boolean.parseBoolean(isLog.trim());
        }
        if (StringUtils.isNotBlank((String)logLevel) && (logLevelEnum = Enums.deserialize(LogLevel.class, logLevel, false)) != null) {
            this.logLevelConfig.setLogLevel(logLevelEnum);
        }
        if (StringUtils.isNotBlank((String)store)) {
            this.storeException = Boolean.parseBoolean(store.trim());
        }
        if (StringUtils.isNotBlank((String)exceptionHandlerBeanName)) {
            this.initWebContext(filterConfig.getServletContext());
            this.exceptionHandler = (ExceptionHandler)this.context.getBean(exceptionHandlerBeanName.trim(), ExceptionHandler.class);
        }
    }

    public void destroy() {
    }

    private void initWebContext(ServletContext sc) {
        if (this.context == null) {
            this.context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        }
    }

    private <T> T spyException(Throwable ex, Class<T> clazz) {
        Throwable th = ex;
        for (int i = 0; i < this.depth && th != null; ++i) {
            if (clazz.isAssignableFrom(th.getClass())) {
                return (T)th;
            }
            th = ex.getCause();
        }
        return null;
    }

    private String obtainErrorPage(Throwable ex) {
        for (Class<?> clazz : this.exceptionMappings.keySet()) {
            if (this.spyException(ex, clazz) == null) continue;
            return this.exceptionMappings.get(clazz);
        }
        return this.defaultPage;
    }

    public boolean judgeLog(Throwable ex) {
        for (Class<?> clazz : this.logMappings.keySet()) {
            if (this.spyException(ex, clazz) == null) continue;
            return this.logMappings.get(clazz);
        }
        return this.isLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block20: {
            try {
                chain.doFilter(req, res);
            }
            catch (Throwable ex) {
                HttpServletRequest request = (HttpServletRequest)req;
                HttpServletResponse response = (HttpServletResponse)res;
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle(ex);
                }
                if (this.judgeLog(ex)) {
                    LogLevelException lle = this.spyException(ex, LogLevelException.class);
                    if (lle != null) {
                        lle.getLogLevelConfig().log(LOG, (Object)lle.getMessage(), lle, new Object[0]);
                    } else {
                        this.logLevelConfig.log(LOG, (Object)ex.getMessage(), ex, new Object[0]);
                    }
                }
                ErrorContext ec = this.spyException(ex, ErrorContext.class);
                CodeMsg error = null;
                if (ec != null) {
                    error = ec.getError();
                    CodeMsg codeMsg = error = error == null ? CodeMsg.FAIL : error;
                    if (StringUtils.isBlank((String)error.getCode())) {
                        error.code(CodeMsg.Code.FAIL_CODE);
                    }
                } else {
                    error = CodeMsg.FAIL;
                }
                if (this.storeException) {
                    request.setAttribute("EXCEPTION_INFO", (Object)ex);
                }
                if (HttpUtils.isAjaxRequest(request)) {
                    response.setContentType("application/json;charset=UTF-8");
                    try {
                        JsonGenerator jsonGenerator = Jacksons.NON_NULL.getFactory().createGenerator((Writer)response.getWriter());
                        Jacksons.NON_NULL.writeValue(jsonGenerator, error);
                        break block20;
                    }
                    catch (Exception jsonEx) {
                        LOG.error((Object)"Write JSON data error!", jsonEx);
                        throw new BaseException("Could not write JSON: " + jsonEx.getMessage(), (Throwable)jsonEx, new Object[0]);
                    }
                }
                if (request.getParameter(BaseConstants.DIALOG_REQ) != null) {
                    Callbacks.callback(Callbacks.none(error), null, response);
                    break block20;
                }
                String errorPage = this.obtainErrorPage(ex);
                if (StringUtils.isNotBlank((String)errorPage)) {
                    if (errorPage.startsWith(REDIRECT_FLAG)) {
                        response.sendRedirect(errorPage.replace(REDIRECT_FLAG, ""));
                    } else {
                        response.setContentType("text/html;charset=UTF-8");
                        String codeMsgStr = Jacksons.NON_NULL.toJson(error);
                        HttpUtils.addCookie("CODE_MSG", codeMsgStr, response);
                        Integer status = this.statusMappings.get(errorPage) == null ? this.defaultStatus : this.statusMappings.get(errorPage);
                        response.setStatus(status.intValue());
                        request.getRequestDispatcher(errorPage).forward((ServletRequest)request, (ServletResponse)response);
                    }
                    break block20;
                }
                throw ex;
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
    }
}

