/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.freemarker;

import com.easycodebox.common.freemarker.JavaTemplateDateFormatFactory;
import com.easycodebox.common.processor.StaticValue;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.util.HashMap;
import javax.servlet.ServletContext;

public class ConfigurationFactory {
    @StaticValue(value="${freemarker.default_encoding}")
    public static String DEFAULT_ENCODING = "UTF-8";
    @StaticValue(value="${freemarker.locale}")
    public static String LOCALE = "zh_CN";
    @StaticValue(value="${freemarker.loader_path}")
    public static String LOADER_PATH = "/";
    @StaticValue(value="${freemarker.template_update_delay}")
    public static String TEMPLATE_UPDATE_DELAY = "3600";
    @StaticValue(value="${freemarker.classic_compatible}")
    public static String CLASSIC_COMPATIBLE = "true";
    @StaticValue(value="${freemarker.datetime_format}")
    public static String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @StaticValue(value="${freemarker.date_format}")
    public static String DATE_FORMAT = "yyyy-MM-dd";
    @StaticValue(value="${freemarker.time_format}")
    public static String TIME_FORMAT = "HH:mm:ss";
    @StaticValue(value="${freemarker.number_format}")
    public static String NUMBER_FORMAT = "#.##";
    @StaticValue(value="${freemarker.tag_syntax}")
    public static String TAG_SYNTAX = "auto_detect";
    private static volatile Configuration INSTANCE = null;
    private static volatile Configuration WEB_INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration instance() throws TemplateException {
        if (INSTANCE != null) return INSTANCE;
        Class<ConfigurationFactory> clazz = ConfigurationFactory.class;
        synchronized (ConfigurationFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = ConfigurationFactory.produce(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration instance(ServletContext servletContext) throws TemplateException {
        if (servletContext == null) {
            return ConfigurationFactory.instance();
        }
        if (WEB_INSTANCE != null) return WEB_INSTANCE;
        Class<ConfigurationFactory> clazz = ConfigurationFactory.class;
        synchronized (ConfigurationFactory.class) {
            if (WEB_INSTANCE != null) return WEB_INSTANCE;
            WEB_INSTANCE = ConfigurationFactory.produce(servletContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return WEB_INSTANCE;
        }
    }

    public static Configuration webInstance() throws NullPointerException {
        if (WEB_INSTANCE == null) {
            throw new NullPointerException("Web Configuration instance is null.");
        }
        return WEB_INSTANCE;
    }

    public static void setServletContext(ServletContext servletContext) throws TemplateException {
        ConfigurationFactory.instance(servletContext);
    }

    private static Configuration produce(ServletContext servletContext) throws TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_24);
        cfg.setDefaultEncoding(DEFAULT_ENCODING);
        cfg.setSetting("locale", LOCALE);
        cfg.setTemplateLoader((TemplateLoader)(servletContext == null ? new ClassTemplateLoader(ConfigurationFactory.class, LOADER_PATH) : new WebappTemplateLoader(servletContext, LOADER_PATH)));
        cfg.setSetting("template_update_delay", TEMPLATE_UPDATE_DELAY);
        cfg.setSetting("classic_compatible", CLASSIC_COMPATIBLE);
        cfg.setSetting("number_format", NUMBER_FORMAT);
        cfg.setSetting("tag_syntax", TAG_SYNTAX);
        HashMap<String, JavaTemplateDateFormatFactory> customDateFormats = new HashMap<String, JavaTemplateDateFormatFactory>();
        customDateFormats.put("date", JavaTemplateDateFormatFactory.INSTANCE);
        cfg.setCustomDateFormats(customDateFormats);
        cfg.setDateTimeFormat("@date " + DATETIME_FORMAT);
        cfg.setDateFormat("@date " + DATE_FORMAT);
        cfg.setTimeFormat("@date " + TIME_FORMAT);
        return cfg;
    }
}

