/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.freemarker;

import com.easycodebox.common.freemarker.ConfigurationFactory;
import com.easycodebox.common.log.slf4j.Logger;
import com.easycodebox.common.log.slf4j.LoggerFactory;
import com.easycodebox.common.processor.Processor;
import com.easycodebox.common.validate.Assert;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;

public class FreemarkerGenerate
implements Processor,
ResourceLoaderAware,
ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FreemarkerGenerate.class);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private ServletContext servletContext;
    private boolean classPathTpl = true;
    private String ftlPath;
    private String outputPath;
    private String encoding = "UTF-8";
    private Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object process() {
        Assert.notBlank(this.ftlPath);
        Assert.notBlank(this.outputPath);
        BufferedWriter out = null;
        try {
            LOG.info((Object)"Start generate file '{0}' by freemarker.", this.outputPath);
            Configuration cfg = ConfigurationFactory.instance(this.classPathTpl ? null : this.servletContext);
            Template tpl = cfg.getTemplate(this.ftlPath);
            Resource resource = this.resourceLoader.getResource(this.outputPath);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resource.getFile()), this.encoding));
            tpl.process((Object)this.properties, (Writer)out);
            LOG.info((Object)"Generate file '{0}' successfully by freemarker.", this.outputPath);
            IOUtils.closeQuietly((Writer)out);
        }
        catch (TemplateException | IOException e) {
            LOG.error((Object)"Freemarker generate file error.", e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return null;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getFtlPath() {
        return this.ftlPath;
    }

    public void setFtlPath(String ftlPath) {
        this.ftlPath = ftlPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isClassPathTpl() {
        return this.classPathTpl;
    }

    public void setClassPathTpl(boolean classPathTpl) {
        this.classPathTpl = classPathTpl;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

