/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.generator.impl;

import com.easycodebox.common.enums.entity.YesNo;
import com.easycodebox.common.generator.exception.BoundReachedException;
import com.easycodebox.common.generator.impl.AbstractStringGenerator;
import java.util.HashMap;
import java.util.Map;

public final class AlphaGenerator
extends AbstractStringGenerator {
    public static char[] alphas = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static Map<Character, Integer> properties = new HashMap<Character, Integer>();

    public AlphaGenerator() {
        this(1, 500, "0", "0", null, YesNo.NO);
    }

    public AlphaGenerator(int increment, int fetchSize, String initialVal, String currentVal, String maxVal, YesNo isCycle) {
        super(increment, fetchSize, initialVal, currentVal, maxVal, isCycle);
        this.initialVal = initialVal.toLowerCase();
        this.maxVal = maxVal == null ? null : maxVal.toLowerCase();
        this.curVal = currentVal.toLowerCase();
    }

    @Override
    public synchronized String nextVal() {
        if (this.hadUsedBeginVal.compareAndSet(false, true)) {
            ++this.genNum;
            return this.curVal;
        }
        if (this.genNum >= this.fetchSize) {
            return null;
        }
        String next = this.addValue(this.increment);
        if (!(this.maxVal == null || this.compare(this.curVal, next) < 0 && this.compare(next, (String)this.maxVal) <= 0 || this.compare(this.curVal, next) > 0 && this.compare(next, (String)this.maxVal) >= 0)) {
            if (this.isCycle == YesNo.YES) {
                next = (String)this.initialVal;
            } else {
                throw new BoundReachedException("IntegerGenerator had reached max value.");
            }
        }
        ++this.genNum;
        this.curVal = next;
        return this.curVal;
    }

    @Override
    public String currentVal() {
        return this.curVal;
    }

    private String addValue(int val) {
        int carryNum = alphas.length;
        int remainVal = val;
        char[] frags = new char[this.curVal.length() > 33 ? this.curVal.length() + 1 : 34];
        char[] curValFrags = this.curVal.toCharArray();
        int i = 0;
        for (i = 1; i <= frags.length; ++i) {
            Integer calVal = remainVal % carryNum;
            Integer charIndex = curValFrags.length - i < 0 ? null : properties.get(Character.valueOf(curValFrags[curValFrags.length - i]));
            Integer total = calVal + (charIndex == null ? -1 : charIndex);
            if (total >= carryNum) {
                frags[frags.length - i] = alphas[total - carryNum];
                remainVal = remainVal / carryNum + 1;
            } else {
                frags[frags.length - i] = alphas[total];
                remainVal /= carryNum;
            }
            if (remainVal == 0 && curValFrags.length - i <= 0) break;
        }
        return new String(frags, frags.length - i, i);
    }

    public static String intToAlpha(int val) {
        char[] buf = new char[33];
        int radix = alphas.length;
        boolean negative = val < 0;
        int charPos = 32;
        if (!negative) {
            val = -val;
        }
        while (val <= -radix) {
            buf[charPos--] = alphas[-(val % radix)];
            val /= radix;
        }
        buf[charPos] = alphas[-val];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 33 - charPos);
    }

    @Override
    public synchronized String nextStepVal(String curVal) {
        this.curVal = curVal;
        this.genNum = 0;
        this.hadUsedBeginVal.set(false);
        return this.addValue(this.fetchSize * this.increment);
    }

    public static void main(String[] args) {
        AlphaGenerator g = new AlphaGenerator(3, 100, "ab", "a", "azz", YesNo.NO);
        for (int i = 0; i < 100; ++i) {
            System.out.println(g.nextVal());
        }
    }

    static {
        for (int i = 0; i < alphas.length; ++i) {
            properties.put(Character.valueOf(alphas[i]), i);
        }
    }
}

