/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.generator.impl;

import com.easycodebox.common.enums.entity.YesNo;
import com.easycodebox.common.generator.AbstractGenerator;
import com.easycodebox.common.generator.exception.BoundReachedException;
import com.easycodebox.common.lang.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;

public final class IntegerGenerator
extends AbstractGenerator<Integer> {
    private final AtomicInteger curVal;

    public IntegerGenerator() {
        this(1, 500, "359", "359", null, YesNo.NO);
    }

    public IntegerGenerator(int increment, int fetchSize, String initialVal, String currentVal, String maxVal, YesNo isCycle) {
        super(increment, fetchSize, initialVal, currentVal, maxVal, isCycle);
        this.initialVal = Integer.parseInt(initialVal);
        this.maxVal = StringUtils.isBlank((String)maxVal) ? Integer.MAX_VALUE : Integer.parseInt(maxVal);
        this.curVal = new AtomicInteger(Integer.parseInt(currentVal));
    }

    @Override
    public Integer nextVal() {
        int next;
        int current;
        if (this.hadUsedBeginVal.compareAndSet(false, true)) {
            ++this.genNum;
            return this.curVal.get();
        }
        if (this.genNum >= this.fetchSize) {
            return null;
        }
        do {
            if ((current = this.curVal.get()) < (next = current + this.increment) && next <= (Integer)this.maxVal || current > next && next >= (Integer)this.maxVal) continue;
            if (this.isCycle == YesNo.YES) {
                next = (Integer)this.initialVal;
                continue;
            }
            throw new BoundReachedException("IntegerGenerator had reached max value.");
        } while (!this.curVal.compareAndSet(current, next));
        ++this.genNum;
        return next;
    }

    @Override
    public Integer currentVal() {
        return this.curVal.intValue();
    }

    @Override
    public Integer nextStepVal(String curVal) {
        Integer curInt = Integer.parseInt(curVal);
        this.curVal.set(curInt);
        this.genNum = 0;
        this.hadUsedBeginVal.set(false);
        return curInt + this.fetchSize * this.increment;
    }

    public static void main(String[] args) {
        IntegerGenerator g = new IntegerGenerator();
        for (int i = 0; i < 100; ++i) {
            System.out.println(g.nextVal());
        }
    }
}

