/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.generator.impl;

import com.easycodebox.common.enums.entity.YesNo;
import com.easycodebox.common.generator.AbstractGenerator;
import com.easycodebox.common.generator.exception.BoundReachedException;
import com.easycodebox.common.lang.StringUtils;
import java.util.concurrent.atomic.AtomicLong;

public final class LongGenerator
extends AbstractGenerator<Long> {
    private final AtomicLong curVal;

    public LongGenerator() {
        this(1, 500, "10059", "10059", null, YesNo.NO);
    }

    public LongGenerator(int increment, int fetchSize, String initialVal, String currentVal, String maxVal, YesNo isCycle) {
        super(increment, fetchSize, initialVal, currentVal, maxVal, isCycle);
        this.initialVal = Long.parseLong(initialVal);
        this.maxVal = StringUtils.isBlank((String)maxVal) ? Long.MAX_VALUE : Long.parseLong(maxVal);
        this.curVal = new AtomicLong(Long.parseLong(currentVal));
    }

    @Override
    public Long nextVal() {
        long next;
        long current;
        if (this.hadUsedBeginVal.compareAndSet(false, true)) {
            ++this.genNum;
            return this.curVal.get();
        }
        if (this.genNum >= this.fetchSize) {
            return null;
        }
        do {
            if ((current = this.curVal.get()) < (next = current + (long)this.increment) && next <= (Long)this.maxVal || current > next && next >= (Long)this.maxVal) continue;
            if (this.isCycle == YesNo.YES) {
                next = (Long)this.initialVal;
                continue;
            }
            throw new BoundReachedException("IntegerGenerator had reached max value.");
        } while (!this.curVal.compareAndSet(current, next));
        ++this.genNum;
        return next;
    }

    @Override
    public Long currentVal() {
        return this.curVal.longValue();
    }

    @Override
    public Long nextStepVal(String curVal) {
        Long curInt = Long.parseLong(curVal);
        this.curVal.set(curInt);
        this.genNum = 0;
        this.hadUsedBeginVal.set(false);
        return curInt + (long)(this.fetchSize * this.increment);
    }

    public static void main(String[] args) {
        LongGenerator g = new LongGenerator();
        for (int i = 0; i < 100; ++i) {
            System.out.println(g.nextVal());
        }
    }
}

