/*
 * Decompiled with CFR 0.152.
 */
package com.easycodebox.common.generator.impl;

import com.easycodebox.common.enums.entity.YesNo;
import com.easycodebox.common.generator.exception.BoundReachedException;
import com.easycodebox.common.generator.impl.AbstractStringGenerator;
import com.easycodebox.common.lang.StringUtils;

public final class NumericStringGenerator
extends AbstractStringGenerator {
    public NumericStringGenerator() {
        this(1, 500, "594", "594", null, YesNo.NO);
    }

    public NumericStringGenerator(int increment, int fetchSize, String initialVal, String currentVal, String maxVal, YesNo isCycle) {
        super(increment, fetchSize, initialVal, currentVal, maxVal, isCycle);
        this.initialVal = initialVal;
        this.maxVal = maxVal;
        this.curVal = currentVal;
    }

    @Override
    public synchronized String nextVal() {
        if (this.hadUsedBeginVal.compareAndSet(false, true)) {
            ++this.genNum;
            return this.curVal;
        }
        if (this.genNum >= this.fetchSize) {
            return null;
        }
        String next = this.addValue(this.increment);
        if (!(this.maxVal == null || this.compare(this.curVal, next) < 0 && this.compare(next, (String)this.maxVal) <= 0 || this.compare(this.curVal, next) > 0 && this.compare(next, (String)this.maxVal) >= 0)) {
            if (this.isCycle == YesNo.YES) {
                next = (String)this.initialVal;
            } else {
                throw new BoundReachedException("IntegerGenerator had reached max value.");
            }
        }
        ++this.genNum;
        this.curVal = next;
        return this.curVal;
    }

    @Override
    public String currentVal() {
        return this.curVal;
    }

    private String addValue(int val) {
        int i;
        int fragLength = 18;
        int num = this.curVal.length() % fragLength != 0 ? this.curVal.length() / fragLength + 1 : this.curVal.length() / fragLength;
        int endIndex = this.curVal.length();
        Object[] fragVals = new String[num];
        for (i = num - 1; i >= 0; --i) {
            int bi = this.curVal.length() - fragLength * (num - i);
            bi = bi < 0 ? 0 : bi;
            fragVals[i] = this.curVal.substring(bi, endIndex);
            endIndex = bi;
        }
        for (i = fragVals.length - 1; i >= 0; --i) {
            Long addedVal = Long.parseLong(fragVals[i]) + (long)val;
            int overflowLen = addedVal.toString().length() - fragLength;
            if (overflowLen <= 0) {
                fragVals[i] = addedVal.toString();
                break;
            }
            String t = addedVal.toString().substring(0, overflowLen);
            fragVals[i] = addedVal.toString().substring(overflowLen);
            val = Integer.parseInt(t);
        }
        String newVal = StringUtils.join((Object[])fragVals, (String)"");
        int zeroNum = ((String)this.initialVal).length() - newVal.length();
        if (zeroNum > 0) {
            newVal = StringUtils.repeat((String)"0", (int)zeroNum) + newVal;
        }
        return newVal;
    }

    @Override
    public synchronized String nextStepVal(String curVal) {
        this.curVal = curVal;
        this.genNum = 0;
        this.hadUsedBeginVal.set(false);
        return this.addValue(this.fetchSize * this.increment);
    }

    public static void main(String[] args) {
        NumericStringGenerator g = new NumericStringGenerator(2, 10, "000100", "000100", "100100", YesNo.NO);
        for (int i = 0; i < 10; ++i) {
            System.out.println(g.nextVal());
        }
    }
}

